<?php
namespace App\Helper;
use App\User;
use App\Model\Patient\Patient;
use App\Model\Patient\PatientCount;
use App\Model\Employee\Roleaccess;

class FormHelper
{

    public static function genreateStingPad($length, $invID) {
        $invID += 1;
        return str_pad($invID, $length, '0', STR_PAD_LEFT);
    }

    /*
    * Code-RoleId-UNIQID
    * Example AAH01
    */
    public static function generatingEmployeeId($role_id, $uniqid) {
        $code = \Config::get('formdata.code');
        return $code.$role_id.self::genreateStingPad(3,$uniqid);
    }

    /*
    * Code-RoleId-UNIQID
    * Example AAH01
    */
    public static function generatingPatientId() {
        //$code = \Config::get('formdata.code');
        //return 'P'.self::genreateStingPad(6,$uniqid);

        $year = date('Y');
        $pcnt = Patient::where('created_at', 'like', $year . '%')->count();

        if($pcnt == 0) {
            $patCnt = new PatientCount();
            $patCnt->year  = $year;
            $patCnt->pcount  = 1;
            $patCnt->save();
            return $year.'/1';
        } else {
            $pcntData = PatientCount::where('year', 'like', $year . '%')->first();
            $patCnt = PatientCount::find($pcntData->id);
            $patCnt->pcount  = $pcntData->pcount + 1;
            $patCnt->save();
            return $year.'/'.($pcntData->pcount + 1);
        }
    }

    /*
    * Code-RoleId-UNIQID
    * Example AAH01
    */
    public static function generatingBillReceipt($uniqid) {
        $code = \Config::get('formdata.code');
        return 'P'.self::genreateStingPad(4,$uniqid);
    }

    /*
    * Code-RoleId-UNIQID
    * Example AAH01
    */
    public static function generatingAdmissionId($uniqid) {
        $code = \Config::get('formdata.code');
        return $code.date('ymd').self::genreateStingPad(4,$uniqid);
    }

    /*
    * Code-RoleId-UNIQID
    * Example AAH01
    */
    public static function generatingBillingId($uniqid) {
        $code = \Config::get('formdata.code');
        return $code.'-B'.self::genreateStingPad(4,$uniqid);
    }

    /*
    * Code-RoleId-UNIQID
    * Example AAH01
    */
    public static function generatingSalesId($uniqid) {
        $code = \Config::get('formdata.code');
        return $code.'-PH'.self::genreateStingPad(4,$uniqid);
    }

    public static function bloodGroupById($bloodGroupId)
    {
        foreach (\Config::get('formdata.bloodGroup') as $bloodGroup) {
            if($bloodGroup['id'] == $bloodGroupId)
                return $bloodGroup['text'];
        }
    }
    
    public static function generatingPurchaseId($uniqid) {
        $code = \Config::get('formdata.code');
        return $code.'-P'.self::genreateStingPad(4,$uniqid);
    }    

    public static function statusBtn($text, $type = 'success')
    {
        $type_check = ['success','primary','info','danger','warning'];
        if(!in_array($type, $type_check))
            $type = 'warning'; //Default type when non-type is requested

        return '<button type="button" class="btn btn-'.$type.' btn-sm">'.$text.'</button>';
    }


    public static function bsTags($text)
    {
        $return_str = '';

        foreach (explode(',', $text) as $list) {
            $return_str .= '<span class="badge badge-primary">'.$list.'</span>';    
        }

        return $return_str;
    }

    public static function genderTxt($text)
    {
        $return_str = '';

        if($text == 'm') {
            return 'Male';
        } else if($text == 'f') {
            return 'Female';
        } 
        
        return '';
    }

    public static function roleName($role_id)
    {
        $return_str = '';

        if($role_id == 1) {
            return 'Admin';
        } else if($role_id == 2) {
            return 'Manager';
        } else if($role_id == 3) {
            return 'Sales';
        } else if($role_id == 4) {
            return 'User';
        } 
        
        return '';
    }

    public static function userName($user_id)
    {
        $user = User::find($user_id);
        if(empty($user))
            return 'No Name';
        else
            return $user->firstname.' '.$user->lastname;
    }

    public static function userRole($user_id)
    {
        $user = User::with('role')->find($user_id);
        if(empty($user))
            return '--';
        else
            return $user->role->name;
    }

    public static function userPhone($user_id)
    {
        $user = User::find($user_id);
        if(empty($user))
            return '+971 56 525 9779';
        else
            return $user->mobile;
    }

    public static function userEmail($user_id)
    {
        $user = User::find($user_id);
        if(empty($user))
            return 'admin@knz.ae';
        else
            return $user->email;
    }

    public static function getPaymentText($pay_id)
    {
        $payment = \Config::get('formdata.payment');
        
        foreach ($payment as $pay) {
            if($pay_id == $pay['id']) {
                return $pay['text'];
            }
        }

        return '';
    } 


    public static function getRoleAccess($role_id)
    {
        $roleAccess = Roleaccess::select('module_id')->where('role_id', $role_id)->get()->toArray();

        $access = [];

        foreach ($roleAccess as $key => $v) {
            $access[] =  $v['module_id'];
        }

        return $access;
    } 


    public static function isInArray($needle, $haystack) 
    {
        foreach ($needle as $stack) {
            if (in_array($stack, $haystack)) {
                return true;
            }
        }
        return false;
    }
    


    /**
     * Returns formatted number
     *
     * @param  float   $value
     * @param  integer $decimal
     *
     * @return string
     */
    public static function formatNumber($value, $decimal = 2)
    {
        if (false === filter_var($value, FILTER_VALIDATE_FLOAT)) {
            return $value;
        }

        return number_format($value, $decimal);
    }


    public static function formatdescription($code, $description) {

        if(empty($code)) 
            return $description;
        
        if (substr($description, 0, 1) === '<') {
            $closing_tag_pos = strpos($description, '>');
            
            if ($closing_tag_pos !== false) {
                $html_tag = substr($description, 0, $closing_tag_pos + 1);
                
                $description = substr($description, $closing_tag_pos + 1);
                
                $modified_html_tag = $html_tag . $code . " - ";
                
                $result = $modified_html_tag . $description;
            } else {
                $result = $description;
            }
        } else {
            $result = '<p>'.$code . ' ' . $description.'</p>';
        }
        
        return $result;
    }
}