<?php

namespace App\Http\Controllers;
use Carbon\Carbon;
use App\Model\Product;
use App\Model\Employee;
use App\Model\Quotation;
use App\Model\Customer;

class AdminController extends Controller {

	public  function __construct()
	{
		date_default_timezone_set("Asia/Dubai");
	}
	
	public function index()
	{
		$user = \Auth::user();

		if ($user->isAdmin()) 
		{
			$qcount     = Quotation::count();
			$dqcount    = Quotation::whereDate('created_at', Carbon::today())->count();
		}
		else
		{
			$qcount     = Quotation::where('user_id', $user->id)->count();
			$dqcount    = Quotation::where('user_id', $user->id)->whereDate('created_at', Carbon::today())->count();
		}

		$pcount     = Product::count();		
		$bacount    = 0;
		
		return view('admin.dashboard.index',['pcount'=> $pcount , 
					'qcount' => $qcount,
					'dqcount' => $dqcount,
					'bacount' => $bacount]);
	}
}