<?php

namespace App\Http\Controllers\Employee;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Role;

class RoleController extends Controller
{

	public function getIndex()
    {  
        return view('admin.role.index');
    }

    public function postRoleList(Request $request) {

        $length = isset($request['length']) ? (int)$request['length'] : 10;
        $start = isset($request['start']) ? (int)$request['start'] : 0;


        $roles      = Role::limit($length)->offset($start)->get();
        $role_count = Role::count();
        $lroles = $this->__prepareData($roles);

        $json_data = array(
            "draw"            => intval($request->input('draw')),
            "recordsTotal"    => $role_count,
            "recordsFiltered" => $role_count,
            "data"            => $lroles
        );

        echo json_encode($json_data);
    }

    private function __prepareData($users) {

        $lusers = [];

        foreach ($users as $data) {

            $luser['name']         = $data->name;
            $luser['display_name'] = $data->display_name;
            $luser['description']  = $data->description;
            

            $roleaccessUrl = \URL::to('/roleaccesses/index/').'/'.$data->id;

            $luser['action'] = '<a title="Edit User Details" href="'.$roleaccessUrl.'" class="btn btn-sm btn-warning">Role Access</a>';

            $lusers[] = $luser;
        }

        return $lusers;
    }
 
}