<?php

namespace App\Http\Controllers\Employee;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Role;
use App\Model\Employee\Roleaccess;

class RoleaccessController extends Controller
{
    public function index($role_id)
    {
    	$role       = Role::with('roleaccess')->find($role_id);
    	$allModules = \Config::get('modules');   	

		foreach ($allModules as $ak => $module) {
			foreach ($module as $k => $v) {
				$allModules[$ak][$k]['access'] = 0;

				if(!empty($role->roleaccess)) {
    				foreach ($role->roleaccess as $key => $value) {
    					if($value->module_id  == $allModules[$ak][$k]['id'])
    						$allModules[$ak][$k]['access'] = 1;
    				}

    			}
			}  			
		}

        return view('admin.roleaccess.index', ['role' => $role,
        'allModules' => $allModules]);
    }

    public function update(Request $request) {
    	$input = $request->all();

    	Roleaccess::where('role_id', $request['role_id'])->delete();

    	unset($input['role_id']);
    	unset($input['_token']);

    	$all_role_access = [];
    	$role_access = [];

        foreach ($input as $k => $value) {

        	$eArr = explode('$', $k);

			$text   = strtolower($eArr[0]);
			$module = $eArr[1];

			$role_access['can_see']     = 0;
	        $role_access['can_edit']    = 0;
	        $role_access['can_update']  = 0;
	        $role_access['can_delete']  = 0;


        	if( strpos( $text, 'add' ) !== false ) {  
	            $role_access['can_edit']    = 1;
	            $role_access['can_update']  = 1;
	            $role_access['can_delete']  = 1;
	        } else if( strpos( $text, 'list' ) !== false ) {
	        	$role_access['can_see']     = 1;
	        } else {
	        	$role_access['can_see']     = 1;
	            $role_access['can_edit']    = 1;
	            $role_access['can_update']  = 1;
	            $role_access['can_delete']  = 1;
	        }

            $role_access['role_id']     = $request['role_id'];
            $role_access['module_id']   = $module;

            $all_role_access[] = $role_access;
            $role_access       = [];
        }

        Roleaccess::insert($all_role_access);

        return redirect()->back()->with(['success' => 'Insert Successfully'] );
    }

}
