<?php

namespace App\Http\Controllers\Inventory;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Measure;

class MeasureController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $rows = Measure::get();

        $total = Measure::count();

        foreach ($rows as $row) {

            $editUrl = \URL::to('/measure/edit/') . '/' . $row->id;
            $deleteUrl = \URL::to('/measure/destroy/') . '/' . $row->id;

            $row->action = '<a title="Edit measure Details" href="' . $editUrl . '" class="btn btn-sm btn-warning"><i class="fas fa-edit"></i></a><a style="margin-left:4px" title="Delete measure Details" href="' . $deleteUrl . '" class="btn btn-sm btn-danger"><i class="fas fa-trash-alt"></i></a>';
        }

        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        );

        echo json_encode($json_data);
    }

    public function view()
    {
        $rows = Measure::get();
        return view('inventory.measure.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $details = Measure::get();
        return view('inventory.measure.create')->with('details', $details);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'measure_name' => 'required|unique:measures,name'
        ]);

        try {
            
            Measure::create(['name' => $request['measure_name']]);
            $messageType = 1;
            $message = "Unit created successfully !";

        } catch (\Illuminate\Database\QueryException $ex) {
            $messageType = 2;
            $message = "Unit creation failed !";
        }

        return redirect(url("/measure/create"))->with('messageType', $messageType)->with('message', $message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        dd($id);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $measure = Measure::where('id', $id)->first();
        return view('inventory.measure.edit')->with('measure', $measure);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'measure_name' => 'required|unique:measures,name'
        ]);

        try {

            $measure = Measure::where('id', $id)->update(['name' => $request['measure_name']]);

            $messageType = 1;
            $message = "Unit updated successfully !";

        } catch (\Illuminate\Database\QueryException $ex) {
            $messageType = 2;
            $message = "Unit updation failed !";
        }

        return redirect(url("/measure/view"))->with('messageType', $messageType)->with('message', $message);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {

            Measure::where('id', $id)->delete();

            $messageType = 1;
            $message = "Unit deleted successfully !";

        } catch (\Illuminate\Database\QueryException $ex) {
            $messageType = 2;
            $message = "Unit deletion failed !";
        }

        return redirect(url("/measure/view"))->with('messageType', $messageType)->with('message', $message);
    }
}