<?php

namespace App\Http\Controllers\Inventory;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\PaymentTerms;

class PaymentTermsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $rows = PaymentTerms::get();

        $total = PaymentTerms::count();

        foreach ($rows as $row) {

            $editUrl = \URL::to('/paymentterms/edit/') . '/' . $row->id;
            $deleteUrl = \URL::to('/paymentterms/destroy/') . '/' . $row->id;

            $row->action = '<a title="Edit Payment Terms Details" href="' . $editUrl . '" class="btn btn-sm btn-warning"><i class="fas fa-edit"></i></a><a style="margin-left:4px" title="Delete Payment Terms Details" href="' . $deleteUrl . '" class="btn btn-sm btn-danger"><i class="fas fa-trash-alt"></i></a>';
        }

        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        );

        echo json_encode($json_data);
    }

    public function view()
    {
        $rows = PaymentTerms::get();
        return view('inventory.paymentterms.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $details = PaymentTerms::get();
        return view('inventory.paymentterms.create')->with('details', $details);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|unique:payment_terms,name'
        ]);

        try {
            
            PaymentTerms::create(['name' => $request['name']]);
            $messageType = 1;
            $message = "Payment Terms created successfully !";

        } catch (\Illuminate\Database\QueryException $ex) {
            $messageType = 2;
            $message = "Payment Terms creation failed !";
        }

        return redirect(url("/paymentterms/create"))->with('messageType', $messageType)->with('message', $message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        dd($id);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $paymentTerms = PaymentTerms::where('id', $id)->first();
        return view('inventory.paymentterms.edit')->with('paymentTerms', $paymentTerms);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name' => 'required|unique:payment_terms,name'
        ]);

        try {
            
            PaymentTerms::where('id', $id)->update(['name' => $request['name']]);

            $messageType = 1;
            $message = "Payment Terms updated successfully !";

        } catch (\Illuminate\Database\QueryException $ex) {
            $messageType = 2;
            $message = "Payment Terms updation failed !";
        }

        return redirect(url("/paymentterms/view"))->with('messageType', $messageType)->with('message', $message);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {

            PaymentTerms::where('id', $id)->delete();

            $messageType = 1;
            $message = "Payment Terms deleted successfully !";

        } catch (\Illuminate\Database\QueryException $ex) {
            $messageType = 2;
            $message = "Payment Terms deletion failed !";
        }

        return redirect(url("/paymentterms/view"))->with('messageType', $messageType)->with('message', $message);
    }
}
