<?php

namespace App\Http\Controllers\Inventory;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Model\Vat;
use Illuminate\Validation\Rule;

class VatController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $rows = Vat::get();

        $total = Vat::count();

        foreach ($rows as $row) {

            $editUrl = \URL::to('/vat/edit/') . '/' . $row->id;
            $deleteUrl = \URL::to('/vat/destroy/') . '/' . $row->id;

            $row->action = '<a title="Edit Tax Details" href="' . $editUrl . '" class="btn btn-sm btn-warning"><i class="fas fa-edit"></i></a><a style="margin-left:4px" title="Delete Tax Details" href="' . $deleteUrl . '" class="btn btn-sm btn-danger"><i class="fas fa-trash-alt"></i></a>';
        }

        $json_data = array(
            "draw" => intval($request->input('draw')),
            "recordsTotal" => $total,
            "recordsFiltered" => $total,
            "data" => $rows
        );

        echo json_encode($json_data);
    }

    public function view()
    {
        $rows = Vat::get();
        return view('inventory.vat.view');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $details = Vat::get();
        return view('inventory.vat.create')->with('details', $details);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'tax' => [
                'required',
                Rule::unique('vats', 'tax')->whereNull('deleted_at')
            ],
        ]);

        try {
            
            Vat::create(['tax' => $request['tax']]);
            $messageType = 1;
            $message = "Tax created successfully !";

        } catch (\Illuminate\Database\QueryException $ex) {
            $messageType = 2;
            $message = "Tax creation failed !";
        }

        return redirect(url("/vat/create"))->with('messageType', $messageType)->with('message', $message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        dd($id);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $tax = Vat::where('id', $id)->first();
        return view('inventory.vat.edit')->with('tax', $tax);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'tax' => [
                'required',
                Rule::unique('vats', 'tax')->whereNull('deleted_at')
            ],
        ]);

        try {
            
            Vat::where('id', $id)->update(['tax' => $request['tax']]);

            $messageType = 1;
            $message = "Tax updated successfully !";

        } catch (\Illuminate\Database\QueryException $ex) {
            $messageType = 2;
            $message = "Tax updation failed !";
        }

        return redirect(url("/vat/view"))->with('messageType', $messageType)->with('message', $message);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {

            Vat::where('id', $id)->delete();

            $messageType = 1;
            $message = "Tax deleted successfully !";

        } catch (\Illuminate\Database\QueryException $ex) {
            $messageType = 2;
            $message = "Tax deletion failed !";
        }

        return redirect(url("/vat/view"))->with('messageType', $messageType)->with('message', $message);
    }
}
