<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model
{
    use SoftDeletes;

    public $timestamps = true;

    protected $fillable = [
        'name',
        'email',
        'address',
        'contact1',
        'contact2',
        'balance',
        'due',
        'city',
        'country',
        'vat',      
        'payment',
    ];

    protected $guarded = [];

    protected $dates = ['deleted_at'];

    public function quotations()
    {
        return $this->hasMany(Quotation::class);
    }
    public function paymentTerms() 
    {
        return $this->hasOne('App\Model\PaymentTerms','id','payment')->withTrashed();
    }
}
