<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model
{
    use SoftDeletes;

    public $timestamps = true;

    protected $fillable = [
        'name',
        'code',
        'description',
        'unit',
        'price',
        'user_id'
    ];

    protected $guarded = [];

    protected $dates = ['deleted_at'];

    public function items()
    {
        return $this->hasMany('App\Model\QuotationItem');
    }
}
