<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vat extends Model
{
    use SoftDeletes;

    public $timestamps = true;

    protected $fillable = [
        'tax',
    ];

    protected $guarded = [];

    protected $dates = ['deleted_at'];

    public function paymentTerms()
    {
        return $this->hasOne('App\Model\Customer');
    }
}
