<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->string('code')->unique();
            $table->string('email')->unique();
            $table->string('firstname',50);
            $table->string('lastname',50)->nullable();            
            $table->integer('role_id');
            $table->text('address')->nullable();
            $table->string('phnumber',50)->nullable();
            $table->string('mobile',50)->nullable();
            $table->date('dob')->nullable();
            $table->string('sex',1)->nullable();
            $table->string('bloodgroup',4)->nullable();
            $table->tinyInteger('status')->default(1);
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();
            $table->softDeletes();            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
