<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('customers', function(Blueprint $table)
		{
			$table->increments('id');
			$table->string('name', 200);
			$table->string('email', 200);
			$table->string('address', 500);
			$table->bigInteger('contact1')->nullable();
			$table->bigInteger('contact2')->nullable();
			$table->float('balance', 10, 0)->default(0)->unsigned();
			$table->float('due', 10, 0)->default(0)->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('customers');
	}

}
