@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Change Password</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('profile') }}">Profile</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">Change Password</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')

<!-- Basic Form Inputs card start -->
<div class="card">
    <div class="card-header">
        <h5>Change Password</h5>
    </div>
    <div class="card-block">
        <form method="post" action="{{ \URL::to('profile/updatePassword') }}"  enctype="multipart/form-data" data-parsley-validate="">
            {{ csrf_field() }}
            <input type="hidden" name="user_id" value="{{ $user->id }}">

            <div class="form-group row">
                <label for="firstname" class="col-sm-2 col-form-label">New Password <i class="text-danger">*</i></label>
                <div class="col-sm-10">
                    <input type="password" id="password" name="password" class="form-control" data-parsley-minlength="6" data-parsley-maxlength="15" data-parsley-required data-parsley-error-message="This field cannot be empty and value should be greater than 6 and less than 15">
                </div>
            </div>

            <div class="form-group row">
                <label for="lastname" class="col-sm-2 col-form-label">Confirm Password <i class="text-danger">*</i></label>
                <div class="col-sm-10">
                    <input type="password" id="password_confirmation" name="password_confirmation" class="form-control" data-parsley-equalto="#password" data-parsley-required  data-parsley-error-message="Should be same as password feild">
                </div>
            </div>

            <div class="row">
                <label class="col-sm-2"></label>
                <div class="col-sm-10">
                    <button type="submit" class="btn btn-primary m-b-0">Set Password</button>
                </div>
            </div>

           
        </form>
    </div>
</div>

@endsection



