@extends('layouts.app')

@section('header')

<style type="text/css">
  td.details-control {
    background: url('../images/details_open.png') no-repeat center center;
    cursor: pointer;
}
tr.details td.details-control {
    background: url('../images/details_close.png') no-repeat center center;
}
</style>

<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Role</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="#">Role</a>
                </li>
            </ul>
        </div>
    </div>    
</div>

@endsection
@section('content')

<table id="dt-role" class="table table-striped table-bordered" style="width:100%;">
    <thead>
        <tr>
            <th>Name</th>
            <th>Display Name</th>
            <th>Description</th>
            <th>Action</th>
        </tr>
    </thead>
    <tbody>      
    </tbody>
</table>



@endsection


@section('scripts')
@include('layouts.datatables_only_files')

<script type="text/javascript">

$(document).ready(function() {
    var dt = $('#dt-role').DataTable( {
        dom: 'Bfrtip',
        buttons: [
              'excel', 'pdf', 'print'
          ],
        "processing": true,
        "serverSide": true,
        "ajax":{              
                url : "/role/list",
                type: "POST",
                data:{_token: '<?php echo csrf_token(); ?>'},
                async: false,
                error: function(){
                    $(".unit-totals-grid-error").html("");
                    $("#unit-totals-grid").append(
                        '<tbody class="unit-totals-grid-error"><tr><th colspan="32">No data found in the server</th></tr></tbody>'
                    );
                    $("#unit-log-grid_processing").css("display","none"); 
                }
        },
        "columns": [
            { "data": "name" },
            { "data": "display_name" },
            { "data": "description" },
            { "data": "action" }
        ],
        "order": []
    });
 
   
});

</script>

@endsection

