@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Edit Customer</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('customer/view') }}">List Customer</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Edit Customer</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection
@section('content')


<div class="card">
  <div class="card-header">
    <h5>Edit Customer</h5>
  </div>
  <div class="card-block">
    <form class="form-horizontal create_customer" role="form" method="POST" action="{{ url('/customer/update/'.$customer->id) }}">

      {{ csrf_field() }}
      <input type="hidden" value="{{ $customer->vat }}" name="old_vat" />

      <div class="box-body">

        <div class="row">
          <div class="col-sm-6">
            <div class="form-group">
              <label>Client Name</label><br>
              <input type="text" class="form-control" name="name" placeholder="Full name" value="{{ $customer->name }}" required>
            </div>
          </div>

          <div class="col-sm-6">
            <div class="form-group">
              <label>E-mail</label>
              <input type="email" class="form-control" name="email" placeholder="abc@xyz.com" value="{{ $customer->email }}">
            </div>
          </div>

        </div>
                
        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Address</label><br>
              <textarea class="form-control" placeholder="Enter current address ... " name="address" required>{{ $customer->address }}</textarea>
            </div>
          </div>
        </div>     

        <div class="row">  
          <div class="col-sm-6">
            <div class="form-group">
              <label>City</label>
              <input type="text" class="form-control" name="city" value="{{ $customer->city }}">
            </div>
          </div>              
          <div class="col-sm-6">
            <div class="form-group">
              <label>Country</label><br>
              <select id="country" name="country" class="form-control"></select>
            </div>
          </div>
        </div>   

        <div class="row">
          <div class="col-sm-6">
            <div class="form-group">
              <label>Contact Mobile</label><br>
              <input type="text" name="contact1" class ='form-control' required="required" maxlength="20" value="{{ $customer->contact1 }}"/>
            </div>
          </div>

          <div class="col-sm-6">
            <div class="form-group">
              <label>Alternate Mobile</label><br>
              <input type="text" name="contact2" class ='form-control' maxlength="20" value="{{ $customer->contact2 }}"/>
            </div>
          </div>
        </div>

        <div class="row">                
          <div class="col-sm-6">
            <div class="form-group">
              <label>Vat Number</label><br>
              <input type="text" name="vat" class ='form-control' value="{{ $customer->vat }}"/>
            </div>
          </div>

          <div class="col-sm-6">
            <div class="form-group">
                <label>Payment Terms (Help: If Payment terms not in dropdown, <a target="_blank" style="color: #007bff;text-decoration: underline;" href="{{ URL::to('paymentterms/create') }}">Click here to add</a>. Refresh page to see added Payment terms)</label><br>
                <select class="form-control" name="payment">
                @foreach($payments as $payment)
                  @if($customer->payment == $payment->id)
                    <option value="{{ $payment->id }}" selected>{{ ucfirst($payment->name) }}</option>
                  @else
                    <option value="{{ $payment->id }}">{{ ucfirst($payment->name) }}</option>
                  @endif
                @endforeach
              </select>
            </div>
          </div>
        </div>

      </div>
      <!-- /.box-body -->

      <div class="box-footer">
        <button type="reset" class="btn btn-danger pull-left">Reset</button>
        <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-edit"></i> Update</button>
      </div>
    </form>
  </div>
</div>
@endsection

@section('scripts')

<script type="text/javascript">
  var role_raw_data = '{!! $countries !!}';
  var role_data = JSON.parse(role_raw_data);
  var role_id = '{!! $customer->country !!}';

  $("#country").select2({
      data: role_data
  });

  $('#country').val(role_id);
  $('#country').trigger('change'); 
</script>

@endsection
