@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Add Product</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('product/view') }}">List Product</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Add Product</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')


<style>
    a {
        color: #007bff;
    }
</style>

<div class="card">
  <div class="card-header">
    <h5>Add Product</h5>
  </div>
  <div class="card-block">
    <form class="form-horizontal create_product" role="form" method="POST" action="{{ url('/product/store') }}">

      {{ csrf_field() }}
      <input type="hidden" name="user_id" value="{{ \Auth::id() }}">

      <div class="box-body">
        
        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Product Code</label><br>
              <input type="text" class="form-control" name="code" required>
            </div>
          </div>
        </div>

        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Short Description</label><br>
              <input type="text" class="form-control" name="name" required>
            </div>
          </div>
        </div>

        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Long Description</label><br>
              <textarea id="summernote" class="form-control" name="description" required></textarea>
            </div>
          </div>
        </div> 

        <div class="row">
          <div class="col-sm-6">
            <div class="form-group">
              <label>Unit (Help: If unit not in dropdown, <a target="_blank" style="color: #007bff;text-decoration: underline;" href="{{ URL::to('measure/create') }}">Click here to add</a>. Refresh page to see added unit)</label><br>
              <select class="form-control" name="unit">
                @foreach($measurements as $g)
                  <option value="{{ $g->name }}">{{ ucfirst($g->name) }}</option>
                @endforeach
              </select>
            </div>
          </div>
          
        </div>

        <div class="row">
          <div class="col-sm-6">
            <div class="form-group">
              <label>Price</label><br>
              <input type="text" class="form-control" name="price" placeholder="0.0" required>
            </div>
          </div>
        </div>
       
      </div>
      <!-- /.box-body -->

      <div class="box-footer">
        <button type="reset" class="btn btn-danger pull-left">Reset</button>
        <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-plus"></i> Add</button>
      </div>
    </form>
  </div>
</div>  
@endsection

@section('scripts')
  <script type="text/javascript" src="{{ \URL::asset('js/summernote-bs4.min.js') }}"></script>
  @include('inventory.product.inc.script')
@endsection

