@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Product Tracking</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('product/view') }}">List Product</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Product Tracking</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')

<div class="card">
  <div class="card-block">
      <div class="box-body">
        <p><b>Name:</b> {{ $product->name }}</p>
        <p><b>Code:</b> {{ $product->code }}</p>
        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label><b>Description</b></label><br>
              <textarea id="summernote" class="form-control" name="description">{{ $product->description }}</textarea>
            </div>
          </div>
        </div>       
    </div>
</div>

<div style="padding: 2%;">
<table id="tracking" class="table table-striped table-bordered" style="width:100%;">
    <thead>
        <tr>
            <th>Quotation</th>
            <th>Customer</th>
            <th>Quantity</th>
            <th>Total Price</th>
        </tr>
    </thead>
    <tbody class="item_container">
        @foreach($products as $list)
        <tr>                        
            <td>
                <p>{{ $list->quotation_number }}</p>
            </td>
            <td>
                <p>{{ $list->customer_name  }}</p>
            </td>
            <td>
                <p>{{ $list->quantity }}</p>
            </td>
            <td>
                <p>{{ $list->total  }}</p>
            </td>
        </tr>
        @endforeach
    </tbody>
</table>  
</div>
@endsection

@section('scripts')

@include('layouts.datatables_only_files')
  <script type="text/javascript" src="{{ \URL::asset('js/summernote-bs4.min.js') }}"></script>
  @include('inventory.product.inc.script')

  <script type="text/javascript">

    $(document).ready(function() {
      $('#tracking').DataTable({
        info: false,
        ordering: false,
        paging: false
      });
    });
  </script>

  

@endsection