@extends('layouts.app')

@section('header')
<div class="card borderless-card">
  <div class="card-block primary-breadcrumb">
    <div class="breadcrumb-header">
      <h5>View Products</h5>
    </div>
    <div class="page-header-breadcrumb">
      <ul class="breadcrumb-title">
        <li class="breadcrumb-item">
          <a href="{{ \URL::to('/')}}">
            <i class="fas fa-home"></i>
          </a>
        </li>
        <li class="breadcrumb-item"><a href="#">View Products</a>
        </li>
      </ul>
    </div>
  </div>
</div>

<div class="page-body">
    <div class="row">
        <div class="col-md-12">
            <a href="{{ URL::to('product/create') }}" class="btn btn-primary btn-sm float-right"><i class="fas fa-plus-circle"></i> Add Product</a>   
        </div>
    </div>
</div>

@endsection


@section('content')
<div class="table-responsive"> 
  <table id="view-stock" class="table table-striped table-bordered" style="width:100%;">
    <thead>
    <tr>
        <th>Product ID</th>
        <th>Name</th>
        <th>Code</th>
        <th>Unit</th>        
        <th>Created By</th>
        <th>Created At</th>
        <th>Action</th>
    </tr>
    </thead>
  </table>
</div>
@endsection

@section('scripts')
@include('layouts.datatables_only_files')


<script type="text/javascript">

$(document).ready(function() {
    var dt = $('#view-stock').DataTable( {
        dom: 'lBfrtip',
        buttons: [
              'excel', 'pdf', 'print'
          ],
        "lengthMenu" : [[ 10, -1 ],[ '10', 'All' ]],
        "processing": true,
        "serverSide": false,
        "ajax":{              
                url : "/product/index",
                type: "GET",
                data:{_token: '<?php echo csrf_token(); ?>'},
                async: false,
                error: function(){
                    $(".unit-totals-grid-error").html("");
                    $("#unit-totals-grid").append(
                        '<tbody class="unit-totals-grid-error"><tr><th colspan="32">No data found in the server</th></tr></tbody>'
                    );
                    $("#unit-log-grid_processing").css("display","none"); 
                }
        },
        "columns": [
            { "data": "id" },
            { "data": "name" },
            { "data": "code"},
            { "data": "unit" },
            { "data": "username" },
            { "data": "created_on" },
            { "data": "action" }
        ],
        "order": []
    } );
 

});

</script>

@endsection

