@extends('layouts.app')

@section('header')
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Create Quotation</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="{{ \URL::to('/')}}">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="{{ \URL::to('quotation/view') }}">List Quotation</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Create Quotation</a>
                </li>
            </ul>
        </div>
    </div>
</div>

@endsection

@section('content')

<style>
    a {
        color: #007bff;
    }
</style>

<!-- Basic Form Inputs card start -->
<div class="card">
    <div class="card-block">
    <form id="paymentForm" method="post" action="{{ url('quotation/store') }}" data-parsley-validate>
    {{ csrf_field() }}

    @if ($errors->any())
        <div class="alert alert-danger mt-3">
            <strong>Oops!</strong> Please fix the following errors:<br>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="row">
        <div class="col-xl-6 col-md-6">            
            <div class="form-group">
                <label for="customer_id">Customer</label>
                <select class="form-control" id="customer_id" name="customer_id" required>
                    <option value="">-- Select Customer --</option>
                    <!-- Add options for customers here -->
                </select>
            </div>

            <div class="form-group">
                <label for="requested_by">Requested By</label>
                <input type="text" class="form-control" id="requested_by" name="requested_by" required>
            </div>

            <div class="form-group">
                <label for="paymentTerms">Payment Terms</label>
                <input type="text" class="form-control" id="paymentTerms" name="paymentTerms" readonly>
            </div>            
        </div>

        <div class="col-xl-6 col-md-6">
            <div class="form-group">
                <label>Date</label>
                <input type="text" class="form-control" name="quotation_date" value="{{ date('d-m-Y') }}" readonly>
            </div>

            <div class="form-group">
                <label>Quote Ref.</label>
                <input type="text" class="form-control" name="quotation_ref" value="{{ $quotationRef }}" autocomplete="off" readonly>
            </div>

            <div class="form-group">
                <label>Enquiry ref.</label>
                <input type="text" class="form-control" name="enquiry_ref" required autocomplete="off">
            </div>
        </div>

        <div class="col-xl-12 col-md-12">
            <div class="form-group">
                <label for="notes">Remarks</label>
                <textarea id="summernote" class="form-control" name="notes">Nil</textarea>
            </div>
        </div>
    </div>

    <hr>

    <div class="row">
        <div class="col-xl-12 col-md-12">
            <div class="box box-default">
                <div class="box-body">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Product Code</th>
                                <th>Product Name</th>
                                <th>Quantity</th>
                                <th>Unit</th>
                                <th>Price</th>
                                <th>Total</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody class="item_container">
                            <!-- Table rows for items will be added dynamically -->
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="6">
                                    <button type="button" class="btn btn-primary add_item_product"><i class="fa fa-plus"></i> Add Item</button>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-6 col-md-6">
            <div class="form-group">
                <label for="deliveryTerms">Delivery Terms</label>
                <textarea class="form-control" style="height: 50px;" name="deliveryTerms"></textarea>
            </div>
            <div class="form-group">
                <label for="notes">Quote Validity</label>
                <select class="form-control" name="quoteValidity">
                    @foreach($quoteValidity as $validity)
                        <option value="{{ $validity['text'] }}">{{ ucfirst($validity['text']) }}</option>
                    @endforeach
                </select>
            </div>
        </div>
        <div class="col-xl-2 col-md-2">
            <!-- You can add more fields here if needed -->
        </div>
        <div class="col-xl-4 col-md-4">
            <div class="form-group">
                <label>Sub Total</label>
                <input type="text" class="form-control sub_total" readonly name="final_total_bill">
            </div>
            <div class="form-group">
                <label>Tax Amount (Help: If Tax not in dropdown, <a target="_blank" style="color: #007bff;text-decoration: underline;" href="{{ URL::to('vat/create') }}">Click here to add</a>. Refresh page to see added unit)</label><br>
                <input type="hidden" class="item_tax_amount" name="tax_amount"/>
                <select class="form-control item_tax_pecentage" name="tax_percentage">
                    @foreach($taxes as $g)
                        @if($g->tax == 5)
                            <option value="{{ $g->tax }}" selected>{{ $g->tax }}</option>
                        @else
                            <option value="{{ $g->tax }}">{{ $g->tax }}</option>
                        @endif     
                    @endforeach
                </select>
            </div>
            <div class="form-group">
                <label>Grand Total</label>
                <input type="text" class="form-control grand_total" readonly name="grand_total">
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12 text-right">
            <button type="submit" class="btn btn-primary">Save</button>
        </div>
    </div>
    </form>

    </div>
</div>

@endsection

@section('scripts')
    <script type="text/javascript" src="{{ \URL::asset('js/summernote-bs4.min.js') }}"></script>
    @include('inventory.quotation.inc.script')
    <script type="text/javascript">

        $('tbody').sortable();
        var customers_raw_data = {!! json_encode($customers) !!};
        var customers_data = JSON.parse(customers_raw_data);


        $("#customer_id").select2({
            data: customers_data
        });  

        $(document.body).on("change","#customer_id",function(){

            $("#paymentTerms").val("");

            $.ajax({
                url: "/customer/getPaymentterms",
                dataType: "json",
                data: {
                    term : this.value
                },
                success: function(data) {
                    console.log(JSON.stringify(data));
                    $("#paymentTerms").val(data.payment_terms.name);
                },
                error: function(xhr, status, error) {
                    console.error("payment request error:", error);
                }
            });
        });

    </script>
@endsection


