<script type="text/javascript">

$( document ).ready(function() {

    $('#summernote').summernote({
        tabsize: 2,
        height: 100,
        toolbar: [
          ['para', ['style', 'ul', 'ol', 'paragraph']],
          ['color', ['color']],
          ['style', ['bold', 'italic', 'underline', 'clear']],
          ['font', ['strikethrough', 'superscript', 'subscript']],
          ['height', ['height']],
          ['fontNames', ['Arial', 'Arial Black', 'Comic Sans MS', 'Courier New', 'Merriweather']],
          ['misc', ['undo', 'redo', 'print', 'help', 'fullscreen']],
          ['insert', ['link']]
      ],
    });

    $(".search_item_name").autocomplete({
        source: function(request, response) {

            var elementName = $(this.element).attr("name");

            $.ajax({
                url: "/product/product_search",
                dataType: "json",
                data: {
                    term : request.term,
                    elementName : elementName
                },
                success: function(data) {
                    response(data);
                },
                error: function(xhr, status, error) {
                    console.error("Autocomplete request error:", error);
                },
                response: function(event, ui) {

                    if (ui.content.length === 0) {
                        $(this).parent().addClass('has-error'); 
                        $(this).next().removeClass('glyphicon-ok').addClass('glyphicon-remove');
                        $(".search_item_name_empty").show();
                        $('.form_submit').hide();
                    } else {
                        $(this).parent().removeClass('has-error');
                        $(this).next().removeClass('glyphicon-remove').addClass('glyphicon-ok');
                        $(".search_item_name_empty").hide();
                        $('.form_submit').show();
                    }
                }
            });
        },
        minLength: 1,
        select: function(event, ui) {               
            $(this).prev().val(ui.item.id);
            $(this).parent().next().children(':first-child').val(1);
            $(this).parent().next().next().children(':first-child').val(ui.item.unit);
            $(this).parent().next().next().next().children(':first-child').val(ui.item.price); 
            $(this).parent().next().next().next().next().children(':first-child').val(ui.item.price);

            calculateBilling();
        }
    });


    $( ".search_patient_name" ).on('keyup',function(){
        $(".search_patient_name_empty").hide();
    });

    $(document).on('click', '.add_item_product', function() {
    // HTML template for a new row
    var newRowHtml = `
        <tr>
            <td width="75px">
                <input type="hidden" name="item_id[]">
                <input type="text" style="min-width: 250px" class="form-control search_item_name" placeholder="Type here ..." name="item_code[]" autocomplete="off">
                <span class="help-block search_item_name_empty" style="display: none;">No Results Found ...</span>
            </td>
            <td>
                <input type="text" class="form-control" name="item_name[]" readonly="">
            </td>
            <td width="75px">
                <input type="number" class="form-control change_item_quantity" name="item_quantity[]" min="1">
            </td>
            <td width="100px">
                <input type="text" class="form-control" name="unit[]" readonly="">
            </td>
            <td width="150px">
                <input type="number" class="form-control item_rate change_item_rate" name="price[]" step="0.1">
            </td>
            <td width="150px">
                <input type="text" class="form-control item_total" name="sub_total[]" readonly="">
            </td>
            <td>
                <button type="button" class="btn btn-danger remove_tr">&times;</button>
            </td>
        </tr>`;

        // Append new row to item container
        $('.item_container').append(newRowHtml);

        // Initialize autocomplete for the newly added item name field
        $('.item_container').find('.search_item_name').last().autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: "/product/product_search",
                    dataType: "json",
                    data: {
                        term: request.term
                    },
                    success: function(data) {
                        response(data);
                    },
                    error: function() {
                        $('.search_item_name_empty').show().text('Error fetching results.');
                    }
                });
            },
            minLength: 1,
            select: function(event, ui) {
                // Update input fields based on selected item
                $(this).prev('input[name="item_id[]"]').val(ui.item.id);
                $(this).closest('tr').find('input[name="item_name[]"]').val(ui.item.name);
                $(this).closest('tr').find('input[name="item_quantity[]"]').val(1);
                $(this).closest('tr').find('input[name="unit[]"]').val(ui.item.unit);
                $(this).closest('tr').find('input[name="price[]"]').val(ui.item.price);
                $(this).closest('tr').find('input[name="sub_total[]"]').val(ui.item.price);
                
                // Calculate billing after selecting an item
                calculateBilling();
            }
        });
    });

    function calculateTaxTotal(quantity, cost) {
        var total = parseFloat(quantity * cost || 0).toFixed(2);
        return total;
    }

    $(document).on('keyup','.change_item_quantity',function() {

        var $input = $(this);
        var quantity = parseFloat($input.val());
        quantity = isNaN(quantity) ? 0 : quantity.toFixed(2);

        var $costInput = $input.parent().next().next().children(':first-child');
        var cost = parseFloat($costInput.val());
        cost = isNaN(cost) ? 0 : cost.toFixed(2);

        var total = calculateTaxTotal(quantity, cost);
        $(this).parent().next().next().next().children(':first-child').val(total);
        
        calculateBilling();  
    });

    $(document).on('keyup','.change_item_rate',function() {

        var $input = $(this);
        var cost = parseFloat($input.val());
        cost = isNaN(cost) ? 0 : cost.toFixed(2);

        var quantity = parseFloat( $(this).parent().prev().prev().children(':first-child').val()) || 0;
        var total = calculateTaxTotal(quantity, cost);
        
        $(this).parent().next().children(':first-child').val(total);
        
        calculateBilling();
    });

    $(document).on('change','.item_tax_pecentage',function() {
        calculateBilling();
    });    

    function calculateBilling() {
        
        var item_total = 0;
        var item_rate = 0;
        var total_tax = 0;
        
        var quantity_array = $(".change_item_quantity").map(function() {
            return parseFloat($(this).val());
        }).get();

        var rate_array = $(".change_item_rate").map(function() {
            return parseFloat($(this).val());
        }).get();
        
        for (var i = 0; i < quantity_array.length; i++) {
            item_rate += quantity_array[i] * rate_array[i];
        }
        
        $(".item_total").each(function() {
            item_total += parseFloat($(this).val());
        });
        
        var ttax = $('.item_tax_pecentage').val();
        
        total_tax = (item_total/100) * ttax;
        var grand_total = item_total + total_tax;

        $('.item_tax_amount').val(total_tax);
        
        $('.sub_total').val(item_total.toFixed(2)); 
        $('.grand_total').val(grand_total.toFixed(2));
    }

     $(document).on('click', '.remove_tr', function(){
        $(this).closest('tr').remove();
        calculateBilling();
    });

    $('#paymentForm').on('submit', function() {


        items = 0;

        $(".item_total").each(function() {
            item_total += 1;
        });

        if(total <= 0) {
            alert("Quotation cannot be created. You need at least one product.");
            return false;
        }
        
        calculateBilling();
        var total = parseFloat($('.grand_total').val());

        if(total <= 0) {
            alert("The grand total value should be greater than 0");
            return false;
        }

        if(confirm('Do you really want to submit the form?')) {
            return true;
        }

        return false;
    });
    
});

</script>
