<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="{{ \URL::asset('css/print.css') }}">

    <title>Quotation Print</title>
</head>

<style>
    .headerGroup:after {
        background-image: url('print_header.png');
    }
</style>

<body>
  
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <table width="100%">
            <thead >
                <tr>
                    <td class="headerGroup">
                        <div class="header-block">
                            <button type="button" onclick="window.print();" class="btn btn-sm btn-primary px-4 py-2 m-4 no-print">Print</button>
                        </div>
                    </td>
                </tr>
            </thead>
            <tfoot>
                <tr>
                    <td class="footerGroup">
                        <div class="footer-block"></div>
                    </td>
                </tr>
            </tfoot>
            <tbody>
                <tr>
                    <td>
                        <div class="page-container">
                            <div class="page">
                              <p class="quoteTitle">QUOTATION</p>

                              <table style="width:100%">
                                  <tr>
                                      <td>
                                        <!-- <p style="margin-bottom: 4px">Client:</p> -->
                                        @php
                                            $displaycitycountry = "";

                                            if(!empty($quotation->customer->city))
                                            {
                                                $displaycitycountry .= $quotation->customer->city.", ";
                                            }

                                            if(!empty($quotation->customer->country))
                                            {
                                                $allcountries = \Config::get('formdata.countries');
                                                foreach($allcountries as $country)
                                                {
                                                    if($country['id'] == $quotation->customer->country)
                                                    {
                                                        $displaycitycountry .= $country['text'].".";
                                                    }
                                                }
                                            }
                                        @endphp
                                            <p class="mbz" style="font-weight: bold;font-size:12pt">{{$quotation->customer->name}}</p>
                                            <p style="font-weight: bold;font-size:12pt;margin-top:-4px;">{{$displaycitycountry }}</p> 
                                            <p>Requested by: {{ $quotation->requested_by }}</p>
                                      </td>
                                        <td class="td2">Date: {{ date('j F Y', strtotime($quotation->quotation_date)) }}
                                            <p class="mbz">Quote ref.: {{ $quotation->quotation_ref }}</p>
                                            <p class="mbz">Enquiry ref.: {{ $quotation->enquiry_ref }}</p>
                                            <p>Prepared by: {{ ucfirst(\FormHelper::userName($quotation->user_id)) }}</p>
                                        </td>
                                  </tr>
                              </table>
                                <hr style="margin: 6px 0px;">
                                <p style="margin-bottom: 0px;">Thank you for the opportunity to quote for your requirement, our most competitive offer with relevant terms & conditions as follows, if there is any clarification, feel free to contact us.</p>
                                <hr style="margin: 6px 0px;">
                                <p style="margin-bottom: 6px;">Remarks: {!! \App\Helper\FormHelper::formatdescription ("", $quotation->notes) !!}</p>
                                <table class="table table-bordered" style="border-color: #bfbfbf;">
                                  <thead style="background-color: #f2f2f2;">
                                      <tr style="font-size: 9pt;text-align: center;vertical-align: middle;">
                                          <th>Item No.</th>
                                          <th>Description</th>
                                          <th>Qty</th>
                                          <th>Unit Price AED.</th>
                                          <th>Total Price AED.</th>
                                      </tr>
                                  </thead>
                                    <tbody id="printTableBody" style="border-top: 0;text-align: center;font-size: 8pt;">
                                      @foreach($quotationList as $list)
                                        <tr>
                                            <td>
                                                <p>{{ $loop->iteration }}. </p>                                         
                                            </td>
                                            <td style="padding-bottom: 0px;">
                                                {!! \App\Helper\FormHelper::formatdescription($list->product->code, $list->product->description) !!}
                                            </td>
                                            <td width="60px">{{ $list->quantity." ".$list->unit }}</td>
                                            <td width="70px" style="text-align: right">{{ number_format($list->price, 2) }}</td>
                                            <td width="70px" style="text-align: right">{{ number_format($list->total, 2) }}</td>
                                        </tr>
                                      @endforeach
                                        <tr>
                                            @if($quotation->taxpercent == 5)
                                                <td class="td2" colspan="4">STANDARD VAT 5%</td>
                                            @else
                                                <td class="td2" colspan="4">VAT {{ $quotation->taxpercent == 0 ? 0 : $quotation->taxpercent }}%</td>
                                            @endif
                                            <td style="text-align: right">{{number_format($quotation->tax, 2) }}</td>
                                        </tr>
                                        <tr>
                                            <td class="td2" colspan="4" style="font-size:9pt"><b>TOTAL AMOUNT - AE DIRHAMS</td>
                                            <td style="text-align: right; font-size: 9pt;"><b>{{ number_format($quotation->total, 2) }}</b></td>
                                        </tr>
                                    </tbody>
                                </table>

                                <table>
                                    <tbody style="line-height: 1.3;">
                                        <tr>
                                            <td style="width: 96px;vertical-align: top;">Delivery Terms</td>
                                            <td style="width: 40px;text-align: center;vertical-align: top;">:</td>
                                            <td>{{ $quotation->deliveryTerms }}</td>
                                        </tr>
                                        <tr>
                                            <td style="width: 96px;vertical-align: top;">Quote Validity</td>
                                            <td style="width: 40px;text-align: center;vertical-align: top;">:</td>
                                            <td>{{ $quotation->quoteValidity }}</td>
                                        </tr>
                                        <tr>
                                            <td style="width: 96px;vertical-align: top;">Payment Terms</td>
                                            <td style="width: 40px;text-align: center;vertical-align: top;">:</td>
                                            <td>{{ $quotation->paymentTerms }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                                
                                <hr  style="margin: 6px 0px;">
                                <p>We hope that above offer meets your requirements, and look forward to receive the valuable Purchase Order. If you need further details, please feel free to contact us.</p>
                                <p style="text-align:center">Prepared by {{ ucfirst(\FormHelper::userName($quotation->user_id)) }}, Email: <a href="mailto:{{  \FormHelper::userEmail($quotation->user_id) }}">{{ \FormHelper::userEmail($quotation->user_id) }}</a> , Office: +971 6 526 9094, Mobile: {{ \FormHelper::userPhone($quotation->user_id) }}</p>

                                <!-- <p class="mbz">Best regards,</p>
                                <p>for KNZ Middle East</p>
                                <br/>
                                <p class="mbz"><b>{{ ucfirst(\FormHelper::userName($quotation->user_id)) }}</b></p>
                                <p class="mbz"><b>{{ \FormHelper::userRole($quotation->user_id) }}</b></p>

                                <p class="mbz">Mobile: {{ \FormHelper::userPhone($quotation->user_id) }} / Email: info@knz.ae</p> -->
                                <!-- <p>E-Mail: info@knz.ae, web: info.knz.ae</p> -->
                                <p style="text-align:center">Appreciate your business / Support !!!</p>
                            </div>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    <!-- ============ srtart absolute header/footer image========== -->
    <div class="header">
      <img src="{{ \URL::asset('images/print_header.png') }}" width="100%" height="100px"
            style="float:left; background-size: cover;">
    </div>
    <div class="footer">
        <hr style="margin-top:48px">
        <p style="text-align:center;margin:0">P. O. Box: 51142, Sharjah, United Arab Emirates</p>
        <p style="text-align:center">Tel: +971 6 526 9094 - Email: info@knz.ae - www.knz.ae</p>

        <!-- <img src="{{ \URL::asset('images/print_footer.png') }}" width="100%" height="80px"
            style="float:left; background-size: cover;"> -->
    </div>
    <!-- <div class="footer">
      <hr>
      <p style="text-align: center;">P. O. Box: 51142, Sharjah, United Arab Emirates</p>
      <p style="text-align: center;">Tel.: +971 6 526 9094 - E-mail: info@knz.ae - www.knz.ae</p>
    </div> -->
    <!-- ============ end absolute header/footer image========== -->

    <!-- Optional JavaScript; choose one of the two! -->
    <!-- Option 1: Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p"
        crossorigin="anonymous"></script>
</body>

</html>
