@php
$user      = \Auth::user();
$user_role = $user->role_id;
$allRoles  = \FormHelper::getRoleAccess($user_role);
@endphp

<nav class="pcoded-navbar">
    <div class="pcoded-inner-navbar main-menu">
        <ul class="pcoded-item pcoded-left-item">
            <li class="pcoded @if(Request::is('/')) active @endif">
                <a href="{{ URL::to('/') }}" style="margin-top:12px">
                    <span class="pcoded-micon"><i class="fas fa-home"></i></span>
                    <span class="pcoded-mtext">Dashboard</span>
                </a>
            </li>

            @if(\FormHelper::isInArray($allRoles,[1,2,3]))

            <li class="pcoded-hasmenu @if( Request::is('employee/create') || Request::is('employee') || Request::is('role')) pcoded-trigger @endif">
                <a href="javascript:void(0)">
                    <span class="pcoded-micon"><i class="fas fa-user"></i></span>
                    <span class="pcoded-mtext">User</span>
                </a>
                <ul class="pcoded-submenu">
                    @if(in_array(1,$allRoles))
                    <li class="@if(Request::is('employee/create')) active @endif">
                        <a href="{{ URL::to('employee/create') }}">
                            <i class="fas fa-plus-square"></i> Add User
                        </a>
                    </li>
                    @endif
                    @if(in_array(2,$allRoles))
                    <li class="@if(Request::is('employee')) active @endif">
                        <a href="{{ \URL::to('employee') }}">
                            <i class="fas fa-list-alt"></i> User List
                        </a>
                    </li>
                    @endif
                    @if(in_array(3,$allRoles))
                    <li class="@if(Request::is('role')) active @endif">
                        <a href="{{ \URL::to('role') }}">
                            <i class="fas fa-list-alt"></i> Role List
                        </a>
                    </li>
                    @endif
                </ul>
            </li>

            @endif

            @if(\FormHelper::isInArray($allRoles,[4,5,12,13]))   

            <li class="pcoded-hasmenu @if( Request::is('customer/create') || Request::is('customer/view')) pcoded-trigger @endif">
                <a href="javascript:void(0)">
                    <span class="pcoded-micon"><i class="fas fa-users"></i></span>
                    <span class="pcoded-mtext">Customers</span>
                </a>
                <ul class="pcoded-submenu">
                    @if(in_array(4,$allRoles))
                    <li class="@if(Request::is('customer/create')) active @endif">
                        <a href="{{ url('customer/create') }}">
                            <i class="fas fa-plus-square"></i> Add Customers
                        </a>
                    </li>
                    @endif
                    @if(in_array(5,$allRoles))
                    <li class="@if(Request::is('customer/view')) active @endif">
                        <a href="{{ url('customer/view') }}">
                            <i class="fas fa-list-alt"></i> View Customers
                        </a>
                    </li>
                    @endif                    
                    @if(in_array(12,$allRoles))
                    <li class="@if(Request::is('paymentterms/create')) active @endif">
                        <a href="{{ url('paymentterms/create') }}">
                            <i class="fas fa-plus-square"></i> Add Payment Terms
                        </a>
                    </li>
                    @endif
                    @if(in_array(13,$allRoles))
                    <li class="@if(Request::is('paymentterms/view')) active @endif">
                        <a href="{{ url('paymentterms/view') }}">
                            <i class="fas fa-list-alt"></i> View Payment Terms
                        </a>
                    </li>
                    @endif
                </ul>
            </li>

            @endif

            @if(\FormHelper::isInArray($allRoles,[6,7,10,11]))

            <li class="pcoded-hasmenu @if( Request::is('product/create') || Request::is('product/view')) pcoded-trigger @endif">
                <a href="javascript:void(0)">
                    <span class="pcoded-micon"><i class="fa fa-cube"></i></span>
                    <span class="pcoded-mtext">Product</span>
                </a>
                <ul class="pcoded-submenu">
                    @if(in_array(6,$allRoles))
                    <li class="@if(Request::is('product/create')) active @endif">
                        <a href="{{ url('product/create') }}">
                            <i class="fas fa-plus-square"></i> Add Product
                        </a>
                    </li>
                    @endif
                    @if(in_array(7,$allRoles))
                    <li class="@if(Request::is('product/view')) active @endif">
                        <a href="{{ url('product/view') }}">
                            <i class="fas fa-list-alt"></i> View Product
                        </a>
                    </li>
                    @endif
                    @if(in_array(10,$allRoles))
                    <li class="@if(Request::is('measure/create')) active @endif">
                        <a href="{{ url('measure/create') }}">
                            <i class="fas fa-plus-square"></i> Add Unit
                        </a>
                    </li>
                    @endif
                    @if(in_array(11,$allRoles))
                    <li class="@if(Request::is('measure/view')) active @endif">
                        <a href="{{ url('measure/view') }}">
                            <i class="fas fa-list-alt"></i> View Unit
                        </a>
                    </li>
                    @endif
                </ul>
            </li>

            @endif

            @if(\FormHelper::isInArray($allRoles,[8,9]))

            <li class="pcoded-hasmenu @if( Request::is('quotation/create') || Request::is('quotation/view')) pcoded-trigger @endif">
                <a href="javascript:void(0)">
                    <span class="pcoded-micon"><i class="fa fa-file"></i></span>
                    <span class="pcoded-mtext">Quotation</span>
                </a>
                <ul class="pcoded-submenu">
                    @if(in_array(8,$allRoles))
                    <li class="@if(Request::is('quotation/create')) active @endif">
                        <a href="{{ url('quotation/create') }}">
                            <i class="fas fa-plus-square"></i> Create Quotation
                        </a>
                    </li>
                    @endif
                    @if(in_array(9,$allRoles))
                    <li class="@if(Request::is('quotation/view')) active @endif">
                        <a href="{{ url('quotation/view') }}">
                            <i class="fas fa-list-alt"></i> View Quotation
                        </a>
                    </li>
                    @endif
                    @if(in_array(14,$allRoles))
                    <li class="@if(Request::is('vat/create')) active @endif">
                        <a href="{{ url('vat/create') }}">
                            <i class="fas fa-plus-square"></i> Add Tax
                        </a>
                    </li>
                    @endif
                    @if(in_array(15,$allRoles))
                    <li class="@if(Request::is('vat/view')) active @endif">
                        <a href="{{ url('vat/view') }}">
                            <i class="fas fa-list-alt"></i> View Tax
                        </a>
                    </li>
                    @endif
                </ul>
            </li>

            @endif

            
        </ul>
    </div>
</nav>
