<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/' , function() {
	return view('auth.login');
});

Route::get('logout', 'Auth\LoginController@logout');

Route::group(['middleware' => ['auth']] , function() {

	Route::get('/', [
    	'uses' => 'AdminController@index',
    	'as' => 'admin.index'
	]);

	Route::get('logs', '\Rap2hpoutre\LaravelLogViewer\LogViewerController@index');
	Route::get('alogs', 'ActivityController@index');

	Route::get('/department' , [
		'uses' => 'Master\DepartmentController@getIndex',
		'as' => 'department.index'
	]);

	Route::get('/department/create' , [
		'uses' => 'Master\DepartmentController@create',
		'as' => 'department.create'
	]);

	Route::post('/department/save' , [
		'uses' => 'Master\DepartmentController@save',
		'as' => 'department.save'
	]);

	Route::get('/department/edit/{id}' , 'Master\DepartmentController@edit');

	Route::post('/department/update' , [
		'uses' => 'Master\DepartmentController@update',
		'as' => 'department.update'
	]);

	Route::get('/department/delete/{id}' , 'Master\DepartmentController@delete');

	//Designation

	Route::get('/designation' , [
		'uses' => 'Master\DesignationController@getIndex',
		'as' => 'designation.index'
	]);

	Route::get('/designation/create' , [
		'uses' => 'Master\DesignationController@create',
		'as' => 'designation.create'
	]);

	Route::post('/designation/save' , [
		'uses' => 'Master\DesignationController@save',
		'as' => 'designation.save'
	]);

	Route::get('/designation/edit/{id}' , 'Master\DesignationController@edit');

	Route::post('/designation/update' , [
		'uses' => 'Master\DesignationController@update',
		'as' => 'designation.update'
	]);

	Route::get('/designation/delete/{id}' , 'Master\DesignationController@delete');

	//Specialization

	Route::get('/specialist' , [
		'uses' => 'Master\SpecialistController@getIndex',
		'as' => 'specialist.index'
	]);

	Route::get('/specialist/create' , [
		'uses' => 'Master\SpecialistController@create',
		'as' => 'specialist.create'
	]);

	Route::post('/specialist/save' , [
		'uses' => 'Master\SpecialistController@save',
		'as' => 'specialist.save'
	]);

	Route::get('/specialist/edit/{id}' , 'Master\SpecialistController@edit');

	Route::post('/specialist/update' , [
		'uses' => 'Master\SpecialistController@update',
		'as' => 'specialist.update'
	]);

	Route::get('/specialist/delete/{id}' , 'Master\SpecialistController@delete');

	//doctor

	Route::get('/doctor' , [
		'uses' => 'Doctor\DoctorController@getIndex',
		'as' => 'doctor.index'
	]);

	Route::get('/doctor/create' , [
		'uses' => 'Doctor\DoctorController@create',
		'as' => 'doctor.create'
	]);

	Route::post('/doctor/save' , [
		'uses' => 'Doctor\DoctorController@save',
		'as' => 'doctor.save'
	]);

	Route::get('/doctor/edit/{id}' , 'Doctor\DoctorController@edit');

	Route::post('/doctor/update' , [
		'uses' => 'Doctor\DoctorController@update',
		'as' => 'doctor.update'
	]);

	Route::get('/doctor/delete/{id}' , 'Doctor\DoctorController@delete');

	Route::post('/doctor/list' , 'Doctor\DoctorController@postDoctorList');

    Route::get('/patientout_view_' , [
    	'uses' => 'Doctor\DoctorController@view',
    	'as' => 'doctor.view'
    ]);


    //employee

	Route::get('/employee' , [
		'uses' => 'Employee\EmployeeController@getIndex',
		'as' => 'employee.index'
	]);

	Route::get('/employee/create' , [
		'uses' => 'Employee\EmployeeController@create',
		'as' => 'employee.create'
	]);

	Route::post('/employee/save' , [
		'uses' => 'Employee\EmployeeController@save',
		'as' => 'employee.save'
	]);

	Route::get('/employee/edit/{id}' , 'Employee\EmployeeController@edit');

	Route::post('/employee/update' , [
		'uses' => 'Employee\EmployeeController@update',
		'as' => 'employee.update'
	]);

	Route::get('/employee/delete/{id}' , 'Employee\EmployeeController@delete');

	Route::post('/employee/list' , 'Employee\EmployeeController@postEmployeeList');

	//role

	Route::get('/role' , [
		'uses' => 'Employee\RoleController@getIndex',
		'as' => 'role.index'
	]);

	Route::post('/role/list' , 'Employee\RoleController@postRoleList');

	//roleaccesses

	Route::get('/roleaccesses/index/{role_id}' , 'Employee\RoleaccessController@index');

	Route::post('/roleaccesses/update' , [
		'uses' => 'Employee\RoleaccessController@update',
		'as' => 'roleaccesses.update'
	]);

	//patient

	Route::get('/patient' , [
		'uses' => 'Patient\PatientController@getIndex',
		'as' => 'patient.index'
	]);

	Route::get('/patient/create' , [
		'uses' => 'Patient\PatientController@create',
		'as' => 'patient.create'
	]);

	Route::post('/patient/save' , [
		'uses' => 'Patient\PatientController@save',
		'as' => 'patient.save'
	]);

	Route::get('/patient/edit/{id}' , 'Patient\PatientController@edit');

	Route::post('/patient/update' , [
		'uses' => 'Patient\PatientController@update',
		'as' => 'patient.update'
	]);

	Route::get('/patient/delete/{id}' , 'Patient\PatientController@delete');
	Route::get('/patient/printCard/{id}' , 'Patient\PatientController@printCard');
	Route::get('/patient/printCase/{id}' , 'Patient\PatientController@printCase');	
	Route::get('/patient/history/{id}' , 'Patient\PatientController@history');

	Route::post('/patient/list' , 'Patient\PatientController@postPatientList');

	//Schedule

	Route::get('/schedule' , [
		'uses' => 'Doctor\ScheduleController@getIndex',
		'as' => 'schedule.index'
	]);

	Route::get('/schedule/create' , [
		'uses' => 'Doctor\ScheduleController@create',
		'as' => 'schedule.create'
	]);

	Route::post('/schedule/save' , [
		'uses' => 'Doctor\ScheduleController@save',
		'as' => 'schedule.save'
	]);

	Route::get('/schedule/edit/{id}' , 'Doctor\ScheduleController@edit');

	Route::post('/schedule/update' , [
		'uses' => 'Doctor\ScheduleController@update',
		'as' => 'schedule.update'
	]);

	Route::get('/schedule/delete/{id}' , 'Doctor\ScheduleController@delete');

	//Appointment

	Route::get('/appointment' , [
		'uses' => 'Patient\AppointmentController@getIndex',
		'as' => 'appointment.index'
	]);

	Route::get('/appointment/history' , [
		'uses' => 'Patient\AppointmentController@gethistory',
		'as' => 'appointment.history'
	]);

	Route::get('/appointment/create' , [
		'uses' => 'Patient\AppointmentController@create',
		'as' => 'appointment.create'
	]);

	Route::post('/appointment/save' , [
		'uses' => 'Patient\AppointmentController@save',
		'as' => 'appointment.save'
	]);

	Route::get('/appointment/edit/{id}' , 'Patient\AppointmentController@edit');

	Route::post('/appointment/update' , [
		'uses' => 'Patient\AppointmentController@update',
		'as' => 'appointment.update'
	]);

	Route::get('/appointment/delete/{id}' , 'Patient\AppointmentController@delete');


	//Document

	Route::get('/document' , [
		'uses' => 'Patient\DocumentController@getIndex',
		'as' => 'document.index'
	]);

	Route::get('/document/create' , [
		'uses' => 'Patient\DocumentController@create',
		'as' => 'document.create'
	]);

	Route::post('/document/save' , [
		'uses' => 'Patient\DocumentController@save',
		'as' => 'document.save'
	]);

	Route::get('/document/edit/{id}' , 'Patient\DocumentController@edit');

	Route::post('/document/update' , [
		'uses' => 'Patient\DocumentController@update',
		'as' => 'document.update'
	]);

	Route::get('/document/delete/{id}' , 'Patient\DocumentController@delete');
	

    //User Profile

    Route::get('/profile' , 'UserProfileController@index');
    Route::get('/profile/edit' , 'UserProfileController@edit');
    Route::post('/profile/update' , 'UserProfileController@update');
    Route::get('/profile/changePassword' , 'UserProfileController@changePassword');
    Route::post('/profile/updatePassword' , 'UserProfileController@updatePassword');


	//seat

	Route::get('/seat' , [
		'uses' => 'SeatController@getIndex',
		'as' => 'seat.index'
	]);

	Route::post('/seat/save' , [
		'uses' => 'SeatController@save',
		'as' => 'seat.save'
	]);

	Route::post('/seat/update' , [
		'uses' => 'SeatController@update',
		'as' => 'seat.update'
	]);

	Route::get('/seat/delete' , [
		'uses' => 'SeatController@delete',
		'as' => 'seat.delete'
	]);

	Route::get('/seat/{seat?}/list' , [
		'uses' => 'SeatController@viewList',
		'as' => 'seat.list'
	]);

	//ReportType

	Route::get('/reportType' , [
		'uses' => 'ReportController@reportTypeIndex',
		'as' => 'reportType.index'
	]);

	Route::post('/reportType/save' , [
		'uses' => 'ReportController@reportTypesave',
		'as' => 'reportType.save'
	]);

	Route::post('/reportType/update' , [
		'uses' => 'ReportController@reportTypeupdate',
		'as' => 'reportType.update'
	]);

	Route::get('/reportType/delete' , [
		'uses' => 'ReportController@reportTypedelete',
		'as' => 'reportType.delete'
	]);

	Route::get('/reportType/list/report' , [
		'uses' => 'ReportController@reportTypeViewList',
		'as' => 'reportType.list'
	]);

	//bedcategory

	Route::get('/bedcategory' , [
		'uses' => 'Bed\BedCategoryController@getIndex',
		'as' => 'bedcategory.index'
	]);

	Route::get('/bedcategory/create' , [
		'uses' => 'Bed\BedCategoryController@create',
		'as' => 'bedcategory.create'
	]);

	Route::post('/bedcategory/save' , [
		'uses' => 'Bed\BedCategoryController@save',
		'as' => 'bedcategory.save'
	]);

	Route::get('/bedcategory/edit/{id}' , 'Bed\BedCategoryController@edit');

	Route::post('/bedcategory/update' , [
		'uses' => 'Bed\BedCategoryController@update',
		'as' => 'bedcategory.update'
	]);

	Route::get('/bedcategory/delete/{id}' , 'Bed\BedCategoryController@delete');

	//bed

	Route::get('/bed' , [
		'uses' => 'Bed\BedController@getIndex',
		'as' => 'bed.index'
	]);

	Route::get('/bed/create' , [
		'uses' => 'Bed\BedController@create',
		'as' => 'bed.create'
	]);

	Route::post('/bed/save' , [
		'uses' => 'Bed\BedController@save',
		'as' => 'bed.save'
	]);

	Route::get('/bed/edit/{id}' , 'Bed\BedController@edit');

	Route::post('/bed/update' , [
		'uses' => 'Bed\BedController@update',
		'as' => 'bed.update'
	]);

	Route::get('/bed/delete/{id}' , 'Bed\BedController@delete');


	//bedassign

	Route::get('/bedassign' , [
		'uses' => 'Bed\BedAssignController@getIndex',
		'as' => 'bedassign.index'
	]);

	Route::get('/bedassign/create' , [
		'uses' => 'Bed\BedAssignController@create',
		'as' => 'bedassign.create'
	]);

	Route::post('/bedassign/save' , [
		'uses' => 'Bed\BedAssignController@save',
		'as' => 'bedassign.save'
	]);

	Route::get('/bedassign/edit/{id}' , 'Bed\BedAssignController@edit');

	Route::post('/bedassign/update' , [
		'uses' => 'Bed\BedAssignController@update',
		'as' => 'bedassign.update'
	]);

	Route::get('/bedassign/delete/{id}' , 'Bed\BedAssignController@delete');
	Route::post('/bedassign/postBedAvailability' , 'Bed\BedAssignController@postBedAvailability');

	//prescription

	Route::get('/prescription' , [
		'uses' => 'Prescription\PrescriptionController@getIndex',
		'as' => 'prescription.index'
	]);

	Route::get('/prescription/create' , [
		'uses' => 'Prescription\PrescriptionController@create',
		'as' => 'prescription.create'
	]);

	Route::post('/prescription/save' , [
		'uses' => 'Prescription\PrescriptionController@save',
		'as' => 'prescription.save'
	]);

	Route::get('/prescription/edit/{id}' , 'Prescription\PrescriptionController@edit');
	Route::get('/prescription/show/{id}' , 'Prescription\PrescriptionController@show');

	Route::post('/prescription/update' , [
		'uses' => 'Prescription\PrescriptionController@update',
		'as' => 'prescription.update'
	]);

	Route::get('/prescription/delete/{id}' , 'Prescription\PrescriptionController@delete');

	Route::post('/prescription/admissionDetails' , [
		'uses' => 'Prescription\PrescriptionController@getAdmissionDetails',
		'as' => 'prescription.admissionDetails'
	]);



	//casestudy

	Route::get('/casestudy' , [
		'uses' => 'Prescription\CaseStudyController@getIndex',
		'as' => 'casestudy.index'
	]);

	Route::get('/casestudy/create' , [
		'uses' => 'Prescription\CaseStudyController@create',
		'as' => 'casestudy.create'
	]);

	Route::post('/casestudy/save' , [
		'uses' => 'Prescription\CaseStudyController@save',
		'as' => 'casestudy.save'
	]);

	Route::get('/casestudy/edit/{id}' , 'Prescription\CaseStudyController@edit');

	Route::post('/casestudy/update' , [
		'uses' => 'Prescription\CaseStudyController@update',
		'as' => 'casestudy.update'
	]);

	Route::get('/casestudy/delete/{id}' , 'Prescription\CaseStudyController@delete');


	//noticeboard

	Route::get('/noticeboard' , [
		'uses' => 'NoticeboardController@getIndex',
		'as' => 'noticeboard.index'
	]);

	Route::get('/noticeboard/create' , [
		'uses' => 'NoticeboardController@create',
		'as' => 'noticeboard.create'
	]);

	Route::post('/noticeboard/save' , [
		'uses' => 'NoticeboardController@save',
		'as' => 'noticeboard.save'
	]);

	Route::get('/noticeboard/edit/{id}' , 'NoticeboardController@edit');

	Route::post('/noticeboard/update' , [
		'uses' => 'NoticeboardController@update',
		'as' => 'noticeboard.update'
	]);

	Route::get('/noticeboard/delete/{id}' , 'NoticeboardController@delete');


	//casemanager

	Route::get('/casemanager' , [
		'uses' => 'CaseManagerController@getIndex',
		'as' => 'casemanager.index'
	]);

	Route::get('/casemanager/create' , [
		'uses' => 'CaseManagerController@create',
		'as' => 'casemanager.create'
	]);

	Route::post('/casemanager/save' , [
		'uses' => 'CaseManagerController@save',
		'as' => 'casemanager.save'
	]);

	Route::get('/casemanager/edit/{id}' , 'CaseManagerController@edit');

	Route::post('/casemanager/update' , [
		'uses' => 'CaseManagerController@update',
		'as' => 'casemanager.update'
	]);

	Route::get('/casemanager/delete/{id}' , 'CaseManagerController@delete');

	//Service

	Route::get('/service' , [
		'uses' => 'Billing\ServiceController@getIndex',
		'as' => 'service.index'
	]);

	Route::get('/service/create' , [
		'uses' => 'Billing\ServiceController@create',
		'as' => 'service.create'
	]);

	Route::post('/service/save' , [
		'uses' => 'Billing\ServiceController@save',
		'as' => 'service.save'
	]);

	Route::get('/service/edit/{id}' , 'Billing\ServiceController@edit');

	Route::post('/service/update' , [
		'uses' => 'Billing\ServiceController@update',
		'as' => 'service.update'
	]);

	Route::get('/service/delete/{id}' , 'Billing\ServiceController@delete');

	//Package

	Route::get('/package' , [
		'uses' => 'Billing\PackageController@getIndex',
		'as' => 'package.index'
	]);

	Route::get('/package/create' , [
		'uses' => 'Billing\PackageController@create',
		'as' => 'package.create'
	]);

	Route::post('/package/save' , [
		'uses' => 'Billing\PackageController@save',
		'as' => 'package.save'
	]);

	Route::get('/package/edit/{id}' , 'Billing\PackageController@edit');

	Route::post('/package/update' , [
		'uses' => 'Billing\PackageController@update',
		'as' => 'package.update'
	]);

	Route::get('/package/delete/{id}' , 'Billing\PackageController@delete');


	//AdvancePayment

	Route::get('/advancePayment' , [
		'uses' => 'Billing\AdvancePaymentController@getIndex',
		'as' => 'advancePayment.index'
	]);

	Route::get('/advancePayment/create' , [
		'uses' => 'Billing\AdvancePaymentController@create',
		'as' => 'advancePayment.create'
	]);

	Route::post('/advancePayment/save' , [
		'uses' => 'Billing\AdvancePaymentController@save',
		'as' => 'advancePayment.save'
	]);

	Route::get('/advancePayment/edit/{id}' , 'Billing\AdvancePaymentController@edit');

	Route::post('/advancePayment/update' , [
		'uses' => 'Billing\AdvancePaymentController@update',
		'as' => 'advancePayment.update'
	]);

	Route::get('/advancePayment/delete/{id}' , 'Billing\AdvancePaymentController@delete');

	//Admission

	Route::get('/admission' , [
		'uses' => 'Billing\AdmissionController@getIndex',
		'as' => 'admission.index'
	]);

	Route::get('/admission/create' , [
		'uses' => 'Billing\AdmissionController@create',
		'as' => 'admission.create'
	]);

	Route::post('/admission/save' , [
		'uses' => 'Billing\AdmissionController@save',
		'as' => 'admission.save'
	]);

	Route::get('/admission/edit/{id}' , 'Billing\AdmissionController@edit');

	Route::post('/admission/update' , [
		'uses' => 'Billing\AdmissionController@update',
		'as' => 'admission.update'
	]);

	Route::get('/admission/delete/{id}' , 'Billing\AdmissionController@delete');

	//Bill

	Route::get('/bill/index', 'Billing\BillController@index');

	Route::get('/bill' , [
		'uses' => 'Billing\BillController@getIndex',
		'as' => 'bill.index'
	]);

	Route::get('/bill/create' , [
		'uses' => 'Billing\BillController@create',
		'as' => 'bill.create'
	]);

	Route::get('/bill/createOutPatient' , [
		'uses' => 'Billing\BillController@createOutPatient',
		'as' => 'bill.createOutPatient'
	]);

	Route::post('/bill/save' , [
		'uses' => 'Billing\BillController@save',
		'as' => 'bill.save'
	]);

	Route::get('/bill/edit/{id}' , 'Billing\BillController@edit');	
	Route::get('/bill/show/{id}' , 'Billing\BillController@show');
	Route::get('/bill/balance/{id}' , 'Billing\BillController@balance');

	Route::post('/bill/update' , [
		'uses' => 'Billing\BillController@update',
		'as' => 'bill.update'
	]);

	Route::get('/bill/delete/{id}' , 'Billing\BillController@delete');

	Route::post('/bill/admissionDetails' , [
		'uses' => 'Billing\BillController@getAdmissionDetails',
		'as' => 'bill.admissionDetails'
	]);


	//report

	/*Route::resource('report','ReportController');

	Route::get('/report_view',[
    	'uses' => 'ReportController@view',
    	'as' => 'report.view'
    ]);

    Route::get('/report_get' , [
    	'uses' => 'ReportController@get',
    	'as' => 'report.get'
    ]);*/

	//OperationType

	Route::get('/operationType' , [
		'uses' => 'OperationController@operationTypeIndex',
		'as' => 'operationType.index'
	]);

	Route::post('/operationType/save' , [
		'uses' => 'OperationController@operationTypesave',
		'as' => 'operationType.save'
	]);

	Route::post('/operationType/update' , [
		'uses' => 'OperationController@operationTypeupdate',
		'as' => 'operationType.update'
	]);

	Route::get('/operationType/delete' , [
		'uses' => 'OperationController@operationTypedelete',
		'as' => 'operationType.delete'
	]);

	Route::get('/operationType/list/operation' , [
		'uses' => 'OperationController@operationTypeViewList',
		'as' => 'operationType.list'
	]);

	//operation

	Route::resource('operation','OperationController');

	Route::get('/operation_view',[
    	'uses' => 'OperationController@view',
    	'as' => 'operation.view'
    ]);

    Route::get('/operation_get' , [
    	'uses' => 'OperationController@get',
    	'as' => 'operation.get'
    ]);

	//Patient

	/*Route::get('/patient' , [
		'uses' => 'PatientController@getIndex',
		'as' => 'patient.index'
	]);

	Route::post('/patient/save' , [
		'uses' => 'PatientController@save',
		'as' => 'patient.save'
	]);

	Route::post('/patient/update' , [
		'uses' => 'PatientController@update',
		'as' => 'patient.update'
	]);

	Route::get('/patient/delete' , [
		'uses' => 'PatientController@delete',
		'as' => 'patient.delete'
	]);

	Route::get('/patient/admit/list' , [
		'uses' => 'PatientController@viewList',
		'as' => 'patient.list'
	]);*/

    Route::get('/api/patient_search' , [
        'uses' => 'ApiController@patientSearch',
        'as' => 'apipatient.search'
    ]);

    Route::get('/api/operationtype_create' , [
        'uses' => 'ApiController@patientCreate',
        'as' => 'apipatient.create'
    ]);

    Route::get('/create_invoice', [
    	'uses' => 'InvoiceController@getIndex',
    	'as' => 'invoice.create_invoce'
    ]);

    Route::get('/invoice_view',[
    	'uses' => 'InvoiceController@view',
    	'as' => 'invoice.view'
    ]);

    Route::resource('invoice', 'InvoiceController');

    Route::resource('ecategory' , 'EmployeeCategoryController');

    Route::resource('marketing','MarketingController');

   // Route::resource('specialist','SpecialistController');

   

    Route::resource('village','VillageController');

    Route::resource('patientout','PatientOutController');

    Route::get('/patientout_api' , function(){
	   $doctor_id = Input::get('doctor_id');
	   $doctors = Doctor::where('id', $doctor_id)->get();
	   return Response::json($doctors); 	
	});

    Route::resource('invoiceout','InvoiceOutController');

    Route::get('/invoiceout_view',[
    	'uses' => 'InvoiceOutController@view',
    	'as' => 'invoiceout.view'
    ]);

    Route::get('/invoiceout_refund' , [
    	'uses' => 'InvoiceOutController@refund',
    	'as' => 'invoiceout.refund'
    ]);

    Route::get('/invoiceout_paid_list',[
    	'uses' => 'InvoiceOutController@paidList',
    	'as' => 'invoiceout.paidlist'
    ]);

    Route::resource('searchrf','SearchRfController');//Reference Fund : rf
    Route::get('searchrf_marketing_view', [
    	'uses' => 'SearchRFController@view',
    	'as' => 'marketing.view'
    ]);

    Route::get('/reportout_village' , function(){
	   $marketing_id = Input::get('marketing_id');
	   $villages = Village::where('marketing_id', $marketing_id)->get();
	   return Response::json($villages); 	
	});

	Route::get('daily_accounce' , [
		'uses' => 'TotalReportController@dailyAccounce' ,
		'as' => 'daily_accounce'
	]);

	Route::get('monthly_accounce' , [
		'uses' => 'TotalReportController@monthlyAccounce' ,
		'as' => 'monthly_accounce'
	]);

	Route::get('/daily_entry_hospital' , [
		'uses' => 'TotalReportController@dailyEntryHospital',
		'as' => 'daily_entry_hospital'
	]);

	Route::get('/daily_delivary_hospital' , [
		'uses' => 'TotalReportController@dailyDelivaryHospital',
		'as' => 'daily_delivary_hospital'
	]);

	Route::get('/patient_details', [
		'uses' => 'PatientController@details',
		'as' => 'patient.details'
	]);

	Route::get('/monthly_entry_hospital' , [
		'uses' => 'TotalReportController@monthlyEntryHospital',
		'as' => 'monthly_entry_hospital'
	]);

	Route::get('/monthly_delivary_hospital' , [
		'uses' => 'TotalReportController@monthlyDelivaryHospital',
		'as' => 'monthly_delivary_hospital'
	]);

	/*Route::get('/daily_entry_stock' , [
		'uses' => 'TotalReportController@dailyEntryStock',
		'as' => 'daily_entry_stock'
	]);

	Route::get('/daily_delivary_stock' , [
		'uses' => 'TotalReportController@dailyDelivaryStock',
		'as' => 'daily_delivary_stock'
	]);

	Route::get('/monthly_entry_stock' , [
		'uses' => 'TotalReportController@monthlyEntryStock',
		'as' => 'monthly_entry_stock'
	]);

	Route::get('/monthly_delivary_stock' , [
		'uses' => 'TotalReportController@monthlyDelivaryStock',
		'as' => 'monthly_delivary_stock'
	]);*/

	Route::get('/daily_entry_pharmacy' , [
		'uses' => 'TotalReportController@dailyEntrypharmacy',
		'as' => 'daily_entry_pharmacy'
	]);

	Route::get('/daily_delivary_pharmacy' , [
		'uses' => 'TotalReportController@dailyDelivarypharmacy',
		'as' => 'daily_delivary_pharmacy'
	]);

	Route::get('/monthly_entry_pharmacy' , [
		'uses' => 'TotalReportController@monthlyEntrypharmacy',
		'as' => 'monthly_entry_pharmacy'
	]);

	Route::get('/monthly_delivary_pharmacy' , [
		'uses' => 'TotalReportController@monthlyDelivarypharmacy',
		'as' => 'monthly_delivary_pharmacy'
	]);


	Route::get('/autocomplete',array('as'=>'autocomplete','uses'=>'StockController@autocomplete'));

	// Route::get('/user_registration', [
	// 	'uses' => 'RegistrationController@index',
	// 	'as' => 'user.registration'
	// ]);

	Route::resource('user','RegistrationController');
	Route::post('/password_reset' , [
		'uses' => 'RegistrationController@password_reset',
		'as' => 'password_reset'
	]);
	
	Route::group(['prefix' => 'product'], function () {

		Route::get('/create', 'Inventory\ProductController@create');
		Route::post('/store', 'Inventory\ProductController@store');
		Route::get('/view', 'Inventory\ProductController@view');
		Route::get('/index', 'Inventory\ProductController@index');
		Route::get('/show/{id}', 'Inventory\ProductController@show');
		Route::get('/edit/{id}', 'Inventory\ProductController@edit');
		Route::get('/tracker/{id}', 'Inventory\ProductController@tracker');
		Route::post('/update/{id}', 'Inventory\ProductController@update');
		Route::get('/destroy/{id}', 'Inventory\ProductController@destroy');		
		Route::any('/product_search', 'Inventory\ProductController@product_search');

	});

	Route::group(['prefix' => 'customer'], function () {

		Route::get('/create', 'Inventory\CustomerController@create');
		Route::post('/store', 'Inventory\CustomerController@store');
		Route::get('/view', 'Inventory\CustomerController@view');
		Route::get('/index', 'Inventory\CustomerController@index');
		Route::get('/show/{id}', 'Inventory\CustomerController@show');
		Route::get('/edit/{id}', 'Inventory\CustomerController@edit');
		Route::post('/update/{id}', 'Inventory\CustomerController@update');
		Route::get('/destroy/{id}', 'Inventory\CustomerController@destroy');
		Route::get('/getPaymentterms', 'Inventory\CustomerController@getPaymentterms');

	});

	Route::group(['prefix' => 'quotation'], function () {
		Route::get('/create', 'Inventory\QuotationController@create');
		Route::post('/store', 'Inventory\QuotationController@store');
		Route::get('/view', 'Inventory\QuotationController@view');
		Route::get('/index', 'Inventory\QuotationController@index');
		Route::get('/print/{id}', 'Inventory\QuotationController@print');
		Route::get('/show/{id}', 'Inventory\QuotationController@show');
		Route::get('/edit/{id}', 'Inventory\QuotationController@edit');
		Route::post('/update', 'Inventory\QuotationController@update');
		Route::post('/updateStatus', 'Inventory\QuotationController@updateStatus');
		Route::get('/destroy/{id}', 'Inventory\QuotationController@destroy');
	});

	

	Route::group(['prefix' => 'comments'], function () {
		Route::post('/store', 'Inventory\CommentController@store');
	});

	Route::group(['prefix' => 'measure'], function () {

		Route::get('/create', 'Inventory\MeasureController@create');
		Route::post('/store', 'Inventory\MeasureController@store');
		Route::get('/view', 'Inventory\MeasureController@view');
		Route::get('/index', 'Inventory\MeasureController@index');
		Route::get('/show/{id}', 'Inventory\MeasureController@show');
		Route::get('/edit/{id}', 'Inventory\MeasureController@edit');
		Route::post('/update/{id}', 'Inventory\MeasureController@update');
		Route::get('/destroy/{id}', 'Inventory\MeasureController@destroy');

	});

	Route::group(['prefix' => 'paymentterms'], function () {

		Route::get('/create', 'Inventory\PaymentTermsController@create');
		Route::post('/store', 'Inventory\PaymentTermsController@store');
		Route::get('/view', 'Inventory\PaymentTermsController@view');
		Route::get('/index', 'Inventory\PaymentTermsController@index');
		Route::get('/show/{id}', 'Inventory\PaymentTermsController@show');
		Route::get('/edit/{id}', 'Inventory\PaymentTermsController@edit');
		Route::post('/update/{id}', 'Inventory\PaymentTermsController@update');
		Route::get('/destroy/{id}', 'Inventory\PaymentTermsController@destroy');

	});

	Route::group(['prefix' => 'vat'], function () {

		Route::get('/create', 'Inventory\VatController@create');
		Route::post('/store', 'Inventory\VatController@store');
		Route::get('/view', 'Inventory\VatController@view');
		Route::get('/index', 'Inventory\VatController@index');
		Route::get('/show/{id}', 'Inventory\VatController@show');
		Route::get('/edit/{id}', 'Inventory\VatController@edit');
		Route::post('/update/{id}', 'Inventory\VatController@update');
		Route::get('/destroy/{id}', 'Inventory\VatController@destroy');

	});

	Route::group(['prefix' => 'unit'], function () {

		Route::get('/create', 'Inventory\UnitController@create');
		Route::post('/store', 'Inventory\UnitController@store');
		Route::get('/view', 'Inventory\UnitController@view');
		Route::get('/index', 'Inventory\UnitController@index');
		Route::get('/show/{id}', 'Inventory\UnitController@show');
		Route::get('/edit/{id}', 'Inventory\UnitController@edit');
		Route::post('/update/{id}', 'Inventory\UnitController@update');
		Route::get('/destroy/{id}', 'Inventory\UnitController@destroy');

	});
});


Auth::routes();
Route::get('/home', 'HomeController@index');
Route::get('/home', 'HomeController@index')->name('home');
