

<?php $__env->startSection('header'); ?>

<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>My Profile</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('/')); ?>">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="#">Profile</a>
                </li>
            </ul>
        </div>
    </div>    
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>



<div class="col-md-12">
    <div class="card user-card-full">
        <div class="row m-l-0 m-r-0">
            <div class="col-sm-4 bg-c-lite-green user-profile">
                <div class="card-block text-center text-white">
                    <div class="m-b-25">
                        <img src="<?php echo e((!empty($user->profilepic) ? $user->profilepic :  \URL::asset('images/User-Profile-Image.png')  )); ?>" height="100" width="100" class="img-radius" alt="User-Profile-Image">
                    </div>
                    <h6 class="f-w-600"><?php echo e($user->firstname.' '.$user->lastname); ?></h6>
                    <p>Role: <?php echo e(\FormHelper::roleName($user->role_id)); ?></p>
                    <a title="Edit Profile" href="<?php echo e(\URL::to('/profile/edit')); ?>">
                        <i class="fas fa-edit"></i>
                    </a>
                    <!-- <a href="" title="Print My Profile"><i class="fas fa-print"></i></a> -->
                </div>
            </div>
            <div class="col-sm-8">
                <div class="card-block">
                    <h6 class="m-b-20 p-b-5 b-b-default f-w-600">Information</h6>
                    <div class="row">
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">ID</p>
                            <h6 class="text-muted f-w-400"><?php echo e($user->code); ?></h6>
                        </div>
                        <div class="col-sm-6">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">First Name</p>
                            <h6 class="text-muted f-w-400"><?php echo e($user->firstname); ?></h6>
                        </div>
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">Last Name</p>
                            <h6 class="text-muted f-w-400"><?php echo e($user->lastname); ?></h6>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">Email</p>
                            <h6 class="text-muted f-w-400"><?php echo e($user->email); ?></h6>
                        </div>
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">Mobile</p>
                            <h6 class="text-muted f-w-400"><?php echo e($user->mobile); ?></h6>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">Date of Birth</p>
                            <h6 class="text-muted f-w-400"><?php echo e($user->dob); ?></h6>
                        </div>
                        <div class="col-sm-6">
                            <p class="m-b-10 f-w-600">Status</p>
                            <h6 class="text-muted f-w-400">
                                <?php if($user->status == 1): ?>
                                    <?php echo \FormHelper::statusBtn('Active','success'); ?>

                                <?php else: ?>
                                    <?php echo \FormHelper::statusBtn('Inactive','danger'); ?>

                                <?php endif; ?>
                            </h6>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <p class="m-b-10 f-w-600">Address</p>
                            <h6 class="text-muted f-w-400"><?php echo e($user->address); ?></h6>
                        </div>
                    </div>                    
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>