

<?php $__env->startSection('header'); ?>
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Product Tracking</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('/')); ?>">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="<?php echo e(\URL::to('product/view')); ?>">List Product</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Product Tracking</a>
                </li>
            </ul>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card">
  <div class="card-block">
      <div class="box-body">
        <p><b>Name:</b> <?php echo e($product->name); ?></p>
        <p><b>Code:</b> <?php echo e($product->code); ?></p>
        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label><b>Description</b></label><br>
              <textarea id="summernote" class="form-control" name="description"><?php echo e($product->description); ?></textarea>
            </div>
          </div>
        </div>       
    </div>
</div>

<div style="padding: 2%;">
<table id="tracking" class="table table-striped table-bordered" style="width:100%;">
    <thead>
        <tr>
            <th>Quotation</th>
            <th>Customer</th>
            <th>Quantity</th>
            <th>Total Price</th>
        </tr>
    </thead>
    <tbody class="item_container">
        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>                        
            <td>
                <p><?php echo e($list->quotation_number); ?></p>
            </td>
            <td>
                <p><?php echo e($list->customer_name); ?></p>
            </td>
            <td>
                <p><?php echo e($list->quantity); ?></p>
            </td>
            <td>
                <p><?php echo e($list->total); ?></p>
            </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>  
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<?php echo $__env->make('layouts.datatables_only_files', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
  <script type="text/javascript" src="<?php echo e(\URL::asset('js/summernote-bs4.min.js')); ?>"></script>
  <?php echo $__env->make('inventory.product.inc.script', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

  <script type="text/javascript">

    $(document).ready(function() {
      $('#tracking').DataTable({
        info: false,
        ordering: false,
        paging: false
      });
    });
  </script>

  

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>