

<?php $__env->startSection('header'); ?>
<div class="card borderless-card">
  <div class="card-block primary-breadcrumb">
    <div class="breadcrumb-header">
      <h5>Unit</h5>
    </div>
    <div class="page-header-breadcrumb">
      <ul class="breadcrumb-title">
        <li class="breadcrumb-item">
          <a href="<?php echo e(\URL::to('/')); ?>">
            <i class="fas fa-home"></i>
          </a>
        </li>
        <li class="breadcrumb-item"><a href="#">View Unit </a>
        </li>
      </ul>
    </div>
  </div>
</div>

<div class="page-body">
    <div class="row">
        <div class="col-md-12">
            <a href="<?php echo e(URL::to('measure/create')); ?>" class="btn btn-primary btn-sm float-right"><i class="fas fa-plus-circle"></i> Add Unit</a>   
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<table id="view-measure" class="table table-striped table-bordered" style="width:100%;">
    <thead>
        <tr>
          <th>Unit</th>
          <th>Action</th>
        </tr>
    </thead>
    <tbody>
    </tbody>
</table>



<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<?php echo $__env->make('layouts.datatables_only_files', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>


<script type="text/javascript">

$(document).ready(function() {
    var dt = $('#view-measure').DataTable( {
        dom: 'Bfrtip',
        buttons: [
              'excel', 'pdf', 'print'
          ],
        "processing": true,
        "serverSide": false,
        "ajax":{              
                url : "/measure/index",
                type: "GET",
                data:{_token: '<?php echo csrf_token(); ?>'},
                async: false,
                error: function(){
                    $(".unit-totals-grid-error").html("");
                    $("#unit-totals-grid").append(
                        '<tbody class="unit-totals-grid-error"><tr><th colspan="32">No data found in the server</th></tr></tbody>'
                    );
                    $("#unit-log-grid_processing").css("display","none"); 
                }
        },
        "columns": [
            { "data": "name" },
            { "data": "action" }
        ],
        "order": []
    } );
 

});

</script>

<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>