<?php $__env->startSection('header'); ?>
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>My Profile</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('/')); ?>">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('profile')); ?>">Profile</a>
                </li>
                <li class="breadcrumb-item">
                    <a href="#">My Profile</a>
                </li>
            </ul>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Basic Form Inputs card start -->
<div class="card">
    <div class="card-header">
        <h5>Edit Doctor</h5>
    </div>
    <div class="card-block">
        <form method="post" action="<?php echo e(\URL::to('profile/update')); ?>"  enctype="multipart/form-data" data-parsley-validate="">
            <?php echo e(csrf_field()); ?>

            <input type="hidden" name="user_id" value="<?php echo e($user->id); ?>">

            <div class="form-group row">
                <label for="firstname" class="col-sm-2 col-form-label">First Name <i class="text-danger">*</i></label>
                <div class="col-sm-10">
                    <input type="text" id="firstname" name="firstname" class="form-control" value="<?php echo e($user->firstname); ?>" data-parsley-minlength="2" data-parsley-maxlength="50" data-parsley-required data-parsley-error-message="This field cannot be empty and value should be greater than 1 and less than 50">
                </div>
            </div>

            <div class="form-group row">
                <label for="lastname" class="col-sm-2 col-form-label">Last Name <i class="text-danger">*</i></label>
                <div class="col-sm-10">
                    <input type="text" id="lastname" name="lastname" class="form-control" value="<?php echo e($user->lastname); ?>" data-parsley-minlength="2" data-parsley-maxlength="50" data-parsley-required data-parsley-error-message="This field cannot be empty and value should be greater than 1 and less than 50">
                </div>
            </div>

            <div class="form-group row">
                <label for="address" class="col-sm-2 col-form-label">Address <i class="text-danger">*</i></label>
                <div class="col-sm-10">
                    <textarea rows="5" cols="5" id="address" name="address" class="form-control" data-parsley-required data-parsley-error-message="This field cannot be empty and value should be greater than 10" data-parsley-minlength="10"><?php echo $user->address; ?></textarea>
                </div>
            </div>

            <div class="form-group row">
                 <label for="phnumber" class="col-sm-2 col-form-label">Phone Number</label>
                <div class="col-sm-10">
                    <input type="text" id="phnumber" name="phnumber" class="form-control"data-parsley-minlength="6" data-parsley-maxlength="20" data-parsley-error-message="Value should be greater than 5 and less than 20" value="<?php echo e($user->phnumber); ?>">
                </div>
            </div>

            <div class="form-group row">
                 <label for="mobilenumber" class="col-sm-2 col-form-label">Mobile Number <i class="text-danger">*</i></label>
                <div class="col-sm-10">
                    <input type="text" id="mobilenumber" name="mobilenumber" class="form-control" data-parsley-minlength="10" data-parsley-maxlength="20" data-parsley-required data-parsley-error-message="This field cannot be empty and value should be greater than 9 and less than 20" value="<?php echo e($user->mobile); ?>">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">Profile Picture</label>
                <div class="col-sm-10">
                    <input type="file" id="profilepic" name="profilepic" class="form-control">
                    <?php if(!empty($user->profilepic)): ?>
                        <img src="<?php echo $user->profilepic; ?>" height="100" width="100">
                    <?php endif; ?>
                    
                </div>
            </div>

            <div class="form-group row">
                 <label for="dob" class="col-sm-2 col-form-label">Date of Birth <i class="text-danger">*</i></label>
                <div class="col-sm-10">
                    <div class="input-group">
                        <input type="text" name="dob" class="form-control" id='datetimepicker1'  data-parsley-required data-parsley-error-message="The Field cannot be empty" autocomplete="off" value="<?php echo e(date('d-m-Y',strtotime($user->dob))); ?>">
                        <span class="input-group-addon"><i class="fas fa-calendar-alt"></i></span>
                    </div>
                </div>
            </div>

            <div class="row">
                <label class="col-sm-2"></label>
                <div class="col-sm-10">
                    <button type="submit" class="btn btn-primary m-b-0">Update</button>
                </div>
            </div>

           
        </form>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script type="text/javascript">
    var FromEndDate = new Date();

    $('#datetimepicker1').datetimepicker({
        format: 'DD-MM-YYYY',
        ignoreReadonly: true,
        maxDate: 'now'
    });
</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>