

<?php $__env->startSection('header'); ?>
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Edit Customer</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('/')); ?>">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="<?php echo e(\URL::to('customer/view')); ?>">List Customer</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Edit Customer</a>
                </li>
            </ul>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


<div class="card">
  <div class="card-header">
    <h5>Edit Customer</h5>
  </div>
  <div class="card-block">
    <form class="form-horizontal create_customer" role="form" method="POST" action="<?php echo e(url('/customer/update/'.$customer->id)); ?>">

      <?php echo e(csrf_field()); ?>

      <input type="hidden" value="<?php echo e($customer->vat); ?>" name="old_vat" />

      <div class="box-body">

        <div class="row">
          <div class="col-sm-6">
            <div class="form-group">
              <label>Client Name</label><br>
              <input type="text" class="form-control" name="name" placeholder="Full name" value="<?php echo e($customer->name); ?>" required>
            </div>
          </div>

          <div class="col-sm-6">
            <div class="form-group">
              <label>E-mail</label>
              <input type="email" class="form-control" name="email" placeholder="abc@xyz.com" value="<?php echo e($customer->email); ?>">
            </div>
          </div>

        </div>
                
        <div class="row">
          <div class="col-sm-12">
            <div class="form-group">
              <label>Address</label><br>
              <textarea class="form-control" placeholder="Enter current address ... " name="address" required><?php echo e($customer->address); ?></textarea>
            </div>
          </div>
        </div>     

        <div class="row">  
          <div class="col-sm-6">
            <div class="form-group">
              <label>City</label>
              <input type="text" class="form-control" name="city" value="<?php echo e($customer->city); ?>">
            </div>
          </div>              
          <div class="col-sm-6">
            <div class="form-group">
              <label>Country</label><br>
              <select id="country" name="country" class="form-control"></select>
            </div>
          </div>
        </div>   

        <div class="row">
          <div class="col-sm-6">
            <div class="form-group">
              <label>Contact Mobile</label><br>
              <input type="text" name="contact1" class ='form-control' required="required" maxlength="20" value="<?php echo e($customer->contact1); ?>"/>
            </div>
          </div>

          <div class="col-sm-6">
            <div class="form-group">
              <label>Alternate Mobile</label><br>
              <input type="text" name="contact2" class ='form-control' maxlength="20" value="<?php echo e($customer->contact2); ?>"/>
            </div>
          </div>
        </div>

        <div class="row">                
          <div class="col-sm-6">
            <div class="form-group">
              <label>Vat Number</label><br>
              <input type="text" name="vat" class ='form-control' value="<?php echo e($customer->vat); ?>"/>
            </div>
          </div>

          <div class="col-sm-6">
            <div class="form-group">
                <label>Payment Terms (Help: If Payment terms not in dropdown, <a target="_blank" style="color: #007bff;text-decoration: underline;" href="<?php echo e(URL::to('paymentterms/create')); ?>">Click here to add</a>. Refresh page to see added Payment terms)</label><br>
                <select class="form-control" name="payment">
                <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <?php if($customer->payment == $payment->id): ?>
                    <option value="<?php echo e($payment->id); ?>" selected><?php echo e(ucfirst($payment->name)); ?></option>
                  <?php else: ?>
                    <option value="<?php echo e($payment->id); ?>"><?php echo e(ucfirst($payment->name)); ?></option>
                  <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </select>
            </div>
          </div>
        </div>

      </div>
      <!-- /.box-body -->

      <div class="box-footer">
        <button type="reset" class="btn btn-danger pull-left">Reset</button>
        <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-edit"></i> Update</button>
      </div>
    </form>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
  var role_raw_data = '<?php echo $countries; ?>';
  var role_data = JSON.parse(role_raw_data);
  var role_id = '<?php echo $customer->country; ?>';

  $("#country").select2({
      data: role_data
  });

  $('#country').val(role_id);
  $('#country').trigger('change'); 
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>