<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    <link rel="stylesheet" href="<?php echo e(\URL::asset('css/print.css')); ?>">

    <title>Quotation Print</title>
</head>

<style>
    .headerGroup:after {
        background-image: url('print_header.png');
    }
</style>

<body>
  
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <table width="100%">
            <tbody>
                <tr>
                    <td>
                        <div class="page-container">
                            <div class="page">
                                <div class="">
                                    <img src="<?php echo e(\URL::asset('images/print_header.png')); ?>" width="100%" height="120px"
                                        style="float:left; background-size: cover;">
                                </div>
                              <p class="quoteTitle">QUOTATION</p>

                              <table style="width:100%">
                                  <tr>
                                      <td>Customer:<?php echo e($quotation->customer->name); ?></td>
                                      <td class="td2">Date:<?php echo e(date('d-m-Y')); ?></td>
                                  </tr>
                                  <tr>
                                      <td style="font-weight: bold;"><?php echo e($quotation->customer->address); ?></td>
                                      <td class="td2">Quote Ref.:<?php echo e($quotation->quotation_ref); ?></td>
                                  </tr>
                                  <tr>
                                      <td style="font-weight: bold;"><?php echo e($quotation->customer->contact1); ?></td>
                                      <td class="td2">Enquiry ref.:<?php echo e($quotation->enquiry_ref); ?></td>
                                  </tr>
                                  <tr>
                                      <td>Requested by:</td>
                                      <td class="td2">Prepared by:<?php echo e($quotation->requested_by); ?></td>
                                  </tr>
                              </table>
                                <hr>
                                <p>Thank you for the opportunity to quote for your requirement, our most competitive offer with relevant terms and conditions
as follows, if there is any clarification, feel free to contact us.</p>
                                <div class="box">REMARKS / NOTE:</div>                                
                                <table class="table table-bordered">
                                  <thead style="background-color: #f2f2f2;">
                                      <tr>
                                          <th>Item No.</th>
                                          <th>Description</th>
                                          <th>Quantity</th>
                                          <th>Unit Price AED</th>
                                          <th>Total Price AED</th>
                                      </tr>
                                  </thead>
                                    <tbody>
                                      <?php $__currentLoopData = $quotationList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <p><?php echo e($loop->iteration); ?> </p>                                         
                                            </td>
                                            <td>
                                                <p><?php echo $list->description; ?> </p>                                         
                                            </td>
                                            <td>
                                                <p><?php echo e($list->quantity." ".$list->unit); ?> </p>
                                            </td>
                                            <td>
                                                <p><?php echo e($list->price); ?> </p>
                                            </td>
                                            <td>
                                                <p><?php echo e($list->total); ?> </p>
                                            </td>
                                        </tr>
                                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="td2" colspan="4">STANDARD VAT 5%</td>
                                            <td><?php echo e($quotation->tax); ?></td>
                                        </tr>
                                        <tr>
                                            <td class="td2" colspan="4" style="font-weight: bold;font-size:9px"><b>TOTAL AMOUNT - AE DIRHAMS</td>
                                            <td><?php echo e($quotation->total); ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <table style="width:100%">
                                  <tr>
                                      <td>Brand Name</td>
                                      <td class="tdm2">:</td>
                                      <td>Item no. 1 to 5: ENPAC, USA.</td>
                                  </tr>
                                  <tr>
                                      <td></td>
                                      <td class="tdm2">:</td>
                                      <td>Item no. 6 & 7: ZOXDY Environmental Protection USA.</td>
                                  </tr>
                                  <tr>
                                      <td>Delivery Terms</td>
                                      <td class="tdm2">:</td>
                                      <td>Ex-Stock, subject to prior sale, (1 week required for delivery of stock items) if sold out 10 to 16 weeks.</td>
                                  </tr>
                                  <tr>
                                      <td>Quote Validity</td>
                                      <td class="tdm2">:</td>
                                      <td>30 Days.</td>
                                  </tr>
                                  <tr>
                                      <td>Payment Terms</td>
                                      <td class="tdm2">:</td>
                                      <td>50% with order, balance 30 days credit.</td>
                                  </tr>
                              </table>
                                <hr>
                                <p>We hope that above offer meets your requirements, and look forward to receive the valuable Purchase Order. If you need any further details,
please feel free to contact us.</p><br/>
                                <p style="margin-bottom: 0;">Best regards,</p>
                                <p>for KNZ Middle East</p>
                                <br/><br/>
                                <p style="margin-bottom: 0;"><?php echo e(ucfirst(\FormHelper::userName($quotation->user_id))); ?></p>
                                <p><?php echo e(\FormHelper::userName($quotation->user_id)); ?></p>
                                <p style="text-align:center">Appreciate your business / Support !!!</p>                                   
                                <img src="<?php echo e(\URL::asset('images/print_footer.png')); ?>" width="100%"
                                        style="float:left; background-size: cover;">
                            </div>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table> 
    </div>
    <!-- ============ end absolute header/footer image========== -->

    <!-- Optional JavaScript; choose one of the two! -->
    <!-- Option 1: Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p"
        crossorigin="anonymous"></script>
</body>

</html>