<?php $__env->startSection('header'); ?>
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Quotation Details</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('/')); ?>">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="<?php echo e(\URL::to('quotation/view')); ?>">Quotation</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Quotation Details</a>
                </li>
            </ul>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Basic Form Inputs card start -->
<div class="card">
    <div class="card-block">
        <div class="row">
            <div class="col-xl-6 col-md-6">
                
                <div class="form-group">
                    <label for="customer_id">Customer</label>
                    <address>
                        <b><?php echo e($quotation->customer->name); ?></b><br>
                        <?php echo e($quotation->customer->address); ?><br>
                        <abbr title="Phone">Ph:</abbr> <?php echo e($quotation->customer->contact1); ?>

                    </address>
                </div>

                <div class="form-group">
                    <label for="requested_by">Requested By</label>
                    <p><?php echo e($quotation->requested_by); ?></p>
                </div>
            </div>

            <div class="col-xl-6 col-md-6">
                <div class="form-group">
                    <label>Date</label>
                    <p><?php echo e(date('d-m-Y')); ?></p>
                </div>

                <div class="form-group">
                    <label>Quote Ref.</label>
                    <p><?php echo e($quotation->quotation_ref); ?></p>
                </div>

                <div class="form-group">
                    <label>Enquiry ref.</label>
                    <p><?php echo e($quotation->enquiry_ref); ?></p>
                </div>
            </div>
        </div>

        <hr>

        <div class="row">
            <div class="col-xl-12 col-md-12">
                <div class="box box-default">
                    <div class="box-body">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Product Name</th>
                                    <th>Quantity</th>
                                    <th>Unit</th>
                                    <th>Price</th>
                                    <th>Total</th>
                                </tr>
                            </thead>
                            <tbody class="item_container">
                                <?php $__currentLoopData = $quotationList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <p><?php echo e($list->name); ?> </p>                                         
                                    </td>
                                    <td>
                                        <p><?php echo e($list->quantity); ?> </p>
                                    </td>
                                    <td>
                                        <p><?php echo e($list->unit); ?> </p>
                                    </td>
                                    <td>
                                        <p><?php echo e($list->price); ?> </p>
                                    </td>
                                    <td>
                                        <p><?php echo e($list->total); ?> </p>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-xl-4 col-md-4">
                <div class="form-group">
                    <label for="notes">Notes</label>
                    <p><?php echo e($quotation->notes); ?></p>
                </div>
            </div>
            <div class="col-xl-4 col-md-4">
                <!-- You can add more fields here if needed -->
            </div>
            <div class="col-xl-4 col-md-4">
                <div class="form-group">
                    <label>Sub Total</label>
                    <p><?php echo e($quotation->sub_total); ?></p>
                </div>
                <div class="form-group">
                    <label>Tax Amount</label>
                    <p><?php echo e($quotation->tax); ?></p>
                </div>
                <div class="form-group">
                    <label>Grand Total</label>
                    <p><?php echo e($quotation->total); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="card">
    <div class="card-block">        
        <div class="row">
            <div class="col-md-6">
                <h4><u>Display Comments</u></h4>
                <?php echo $__env->make('inventory.quotation.commentsDisplay', ['comments' => $quotation->comments, 'quotation_id' => $quotation->id], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                <h6><b>Add comment</b></h6>
                <form method="post" action="<?php echo e(\URL::to('comments/store')); ?>">
                    <?php echo e(csrf_field()); ?>

                    <div class="form-group">
                        <label for="comment_body">Comment</label>
                        <textarea id="comment_body" class="form-control" name="body" required  rows="3"></textarea>
                        <input type="hidden" name="quotation_id" value="<?php echo e($quotation->id); ?>">
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn btn-primary">Post Comment</button>
                    </div>
                </form>
            </div>
        </div>  
    </div>
</div>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>