<?php $__env->startSection('header'); ?>
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Create Quotation</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('/')); ?>">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="<?php echo e(\URL::to('quotation/view')); ?>">List Quotation</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Create Quotation</a>
                </li>
            </ul>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<!-- Basic Form Inputs card start -->
<div class="card">
    <div class="card-block">
    <form id="paymentForm" method="post" action="<?php echo e(url('quotation/store')); ?>" data-parsley-validate>
    <?php echo e(csrf_field()); ?>


    <?php if($errors->any()): ?>
        <div class="alert alert-danger mt-3">
            <strong>Oops!</strong> Please fix the following errors:<br>
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="row">
        <div class="col-xl-6 col-md-6">
            
            <div class="form-group">
                <label for="customer_id">Customer</label>
                <select class="form-control" id="customer_id" name="customer_id" required>
                    <option value="">-- Select Customer --</option>
                    <!-- Add options for customers here -->
                </select>
            </div>

            <div class="form-group">
                <label for="requested_by">Requested By</label>
                <input type="text" class="form-control" id="requested_by" name="requested_by" required>
            </div>
        </div>

        <div class="col-xl-6 col-md-6">
            <div class="form-group">
                <label>Date</label>
                <input type="text" class="form-control" name="quotation_date" value="<?php echo e(date('d-m-Y')); ?>" readonly>
            </div>

            <div class="form-group">
                <label>Quote Ref.</label>
                <input type="text" class="form-control" name="quotation_ref" required autocomplete="off">
            </div>

            <div class="form-group">
                <label>Enquiry ref.</label>
                <input type="text" class="form-control" name="enquiry_ref" required autocomplete="off">
            </div>
        </div>
    </div>

    <hr>

    <div class="row">
        <div class="col-xl-12 col-md-12">
            <div class="box box-default">
                <div class="box-body">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Product Name</th>
                                <th>Quantity</th>
                                <th>Unit</th>
                                <th>Price</th>
                                <th>Total</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody class="item_container">
                            <!-- Table rows for items will be added dynamically -->
                        </tbody>
                        <tfoot>
                            <tr>
                                <td colspan="6">
                                    <button type="button" class="btn btn-primary add_item_product"><i class="fa fa-plus"></i> Add Item</button>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-4 col-md-4">
            <div class="form-group">
                <label for="notes">Notes</label>
                <textarea class="form-control" style="height: 60px;" id="notes" name="notes"></textarea>
            </div>
        </div>
        <div class="col-xl-4 col-md-4">
            <!-- You can add more fields here if needed -->
        </div>
        <div class="col-xl-4 col-md-4">
            <div class="form-group">
                <label>Sub Total</label>
                <input type="text" class="form-control final_total_bill" readonly name="final_total_bill">
            </div>
            <div class="form-group">
                <label>Tax Amount</label>
                <input type="text" class="form-control item_tax_amount" readonly name="tax_percent">
            </div>
            <div class="form-group">
                <label>Grand Total</label>
                <input type="text" class="form-control grand_total" readonly name="grand_total">
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12 text-right">
            <button type="submit" class="btn btn-primary">Save</button>
        </div>
    </div>
    </form>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make('inventory.quotation.inc.script', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    <script type="text/javascript">

        $('tbody').sortable();
        var customers_raw_data = '<?php echo $customers; ?>';
        var customers_data = JSON.parse(customers_raw_data);

        $("#customer_id").select2({
            data: customers_data
        });  
    </script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>