

<?php $__env->startSection('header'); ?>
<div class="card borderless-card">
    <div class="card-block primary-breadcrumb">
        <div class="breadcrumb-header">
            <h5>Add Customer</h5>
        </div>
        <div class="page-header-breadcrumb">
            <ul class="breadcrumb-title">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(\URL::to('/')); ?>">
                        <i class="fas fa-home"></i>
                    </a>
                </li>
                <li class="breadcrumb-item"><a href="<?php echo e(\URL::to('customer/view')); ?>">List Customer</a>
                </li>
                <li class="breadcrumb-item"><a href="#">Add Customer</a>
                </li>
            </ul>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>


<div class="card">
  <div class="card-header">
    <h5>Add Customer</h5>
  </div>
  <div class="card-block">
    <form class="form-horizontal create_customer" role="form" method="POST" action="<?php echo e(url('/customer/store')); ?>">

            <?php echo e(csrf_field()); ?>


            <div class="box-body">
              <div class="row">                
                <div class="col-sm-6">
                  <div class="form-group">
                    <label>Client Name</label><br>
                    <input type="text" class="form-control" name="name" placeholder="Full name" required>
                  </div>
                </div>

                <div class="col-sm-6">
                  <div class="form-group">
                    <label>E-mail</label>
                    <input type="email" class="form-control" name="email" placeholder="abc@xyz.com">
                  </div>
                </div>
              </div>

              <div class="row">                
                <div class="col-sm-12">
                  <div class="form-group">
                    <label>Address</label><br>
                    <textarea class="form-control" placeholder="Enter current address ... " name="address" required></textarea>
                  </div>
                </div>
              </div>


              <div class="row">
                <div class="col-sm-6">
                  <div class="form-group">
                    <label>City</label>
                    <input type="text" class="form-control" name="city">
                  </div>
                </div>                
                <div class="col-sm-6">
                  <div class="form-group">
                    <label>Country</label><br>
                    <select id="country" name="country" class="form-control"></select>
                  </div>
                </div>
              </div>
              
              
              <div class="row">                
                <div class="col-sm-6">
                  <div class="form-group">
                    <label>Contact Number</label><br>
                    <input type="text" name="contact1" class ='form-control' maxlength="20" minlength="10"/>
                  </div>
                </div>

                <div class="col-sm-6">
                  <div class="form-group">
                    <label>Alternate Number</label><br>
                    <input type="text" name="contact2" class ='form-control' maxlength="20" minlength="10"/>
                  </div>
                </div>
              </div>

              <div class="row">                
                <div class="col-sm-6">
                  <div class="form-group">
                    <label>Vat Number</label><br>
                    <input type="text" name="vat" class ='form-control'/>
                  </div>
                </div>

                <div class="col-sm-6">
                  <div class="form-group">
                  <label>Payment Terms (Help: If Payment terms not in dropdown, <a target="_blank" style="color: #007bff;text-decoration: underline;" href="<?php echo e(URL::to('paymentterms/create')); ?>">Click here to add</a>. Refresh page to see added Payment terms)</label><br>
                    <select class="form-control" name="payment">
                      <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($payment->id); ?>"><?php echo e(ucfirst($payment->name)); ?></option>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                  </div>
                </div>
              </div>

            </div>
            <!-- /.box-body -->

            <div class="box-footer">
              <button type="reset" class="btn btn-danger pull-left">Reset</button>
              <button type="submit" class="btn btn-primary pull-right"><i class="fa fa-plus"></i> Add</button>
            </div>
    </form>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
$(document).ready(function() {

    var role_raw_data = '<?php echo $countries; ?>';
    var role_data = JSON.parse(role_raw_data);

    $("#country").select2({
        data: role_data
    });
});

</script>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>