<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class ChangePasswordController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
        return view('pages/auth.change-password');
    }
    
    public function changePassword(Request $request)
    {
        $request->validate([
            'current_password' => [
                'required',
                function ($attribute, $value, $fail) {
                    if (!Hash::check($value, auth()->user()->password)) {
                        $fail('The current password is incorrect.');
                    }
                },
            ],
            'password' => 'required|min:8',
            'password_confirmation' => ['same:password'],
        ]);
        
        $user = User::find(auth()->id());

        if ($user) {
            $user->update(['password' => Hash::make($request->password)]);
        } else {
            return redirect()->back()->withErrors(['error' => 'User not found']);
        }

        return redirect()->back()->with('success', 'Password has been updated successfully.');
    }
}