<?php

namespace App\Http\Controllers;
use App\Models\TransactionRegularization;
use App\Services\BioTimeTransactionService;

class DashboardController extends Controller
{
    protected $bioTimeTransactionService;

    public function __construct(BioTimeTransactionService $bioTimeTransactionService)
    {
        $this->bioTimeTransactionService = $bioTimeTransactionService;
    }

    public function index()
    {
        $dashCount = $this->bioTimeTransactionService->getCurrentMonthEmployeeDashboardAttendance();
        $statusCounts = TransactionRegularization::getMonthlyStatusCounts();   
        return view('pages/dashboards.index', ['dashCount' => $dashCount[\Auth::id()], 'statusCounts' => $statusCounts]);
    } 
}
