<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\DataTables\DepartmentDataTable;
use App\Models\Department;
use App\Services\BioTimeDepartmentService;

class DepartmentController extends Controller
{
    protected $bioTimeDepartmentService;

    public function __construct(BioTimeDepartmentService $bioTimeDepartmentService)
    {
        $this->bioTimeDepartmentService = $bioTimeDepartmentService;
    }
    /**
     * Display a listing of the resource.
     */
    public function index(DepartmentDataTable $dataTable)
    {
        return $dataTable->render('pages/departments.list');
    }

    public function syncDepartments()
    {
        $areaData = $this->bioTimeDepartmentService->getDepartments();
        //dd($areaData);

        if(is_null($areaData))
        {           
            return redirect()->route('departments.index')->with('error', 'No data found. Please contact the system administrator.');
        }
        else 
        {
            $updateData = [];
            $createData = [];

            foreach ($areaData as $key => $value) {
                $temp = [];

                $temp['external_id'] = $value['id'];
                $temp['code'] = $value['dept_code'];
                $temp['name'] = $value['dept_name'];
                $temp['parent_dept'] = $value['parent_dept'];

                // Check if the department already exists by its code
                $department = Department::where('code', $temp['code'])->first();

                if ($department) {
                    // If the department exists, add to update array
                    $updateData[] = [
                        'id' => $department->id, // Assuming 'id' is the primary key
                        'name' => $temp['name'],
                    ];
                } else {
                    // If the department doesn't exist, add to create array
                    $createData[] = $temp;
                }
            }

            // Bulk create new departments
            if (!empty($createData)) {
                Department::insert($createData);
            }

            // Bulk update existing departments
            if (!empty($updateData)) {
                foreach ($updateData as $data) {
                    Department::where('id', $data['id'])->update(['name' => $data['name']]);
                }
            }

            return redirect()->route('departments.index')->with('success', count($createData). ' new records inserted, '.count($updateData) .' records updated successfully!');
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
