<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\BioTimePositionService;
use App\Models\Position;
use App\DataTables\PositionDataTable;

class PositionController extends Controller
{
    
    protected $bioTimePositionService;

    public function __construct(BioTimePositionService $bioTimePositionService)
    {
        $this->bioTimePositionService = $bioTimePositionService;
    }
    /**
     * Display a listing of the resource.
     */
    public function index(PositionDataTable $dataTable)
    {
        return $dataTable->render('pages/positions.list');
    }

    public function syncPositions()
    {
        $areaData = $this->bioTimePositionService->getPositions();
        //dd($areaData);

        if(is_null($areaData))
        {           
            return redirect()->route('positions.index')->with('error', 'No data found. Please contact the system administrator.');
        }
        else 
        {
            $updateData = [];
            $createData = [];

            foreach ($areaData as $key => $value) {
                $temp = [];

                $temp['external_id'] = $value['id'];
                $temp['code'] = $value['position_code'];
                $temp['name'] = $value['position_name'];
                $temp['parent_position'] = $value['parent_position'];                
                $temp['parent_position_name'] = $value['parent_position_name'];

                // Check if the position already exists by its code
                $position = Position::where('code', $temp['code'])->first();

                if ($position) {
                } else {
                    // If the position doesn't exist, add to create array
                    $createData[] = $temp;
                }
            }

            // Bulk create new positions
            if (!empty($createData)) {
                Position::insert($createData);
            }

            return redirect()->route('positions.index')->with('success', count($createData). ' new records inserted, '.count($updateData) .' records updated successfully!');
        }
    }
}
