<?php

namespace App\Http\Controllers;

use App\Models\School;
use Illuminate\Http\Request;
use App\DataTables\SchoolsDataTable;
use App\Services\BioTimeAreaService;
use Faker\Factory as Faker;

class SchoolController extends Controller
{
    protected $bioTimeAreaService;

    public function __construct(BioTimeAreaService $bioTimeAreaService)
    {
        $this->bioTimeAreaService = $bioTimeAreaService;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(SchoolsDataTable $dataTable)
    {
        return $dataTable->render('pages/schools.list');
        //$schools = School::all();
        //return response()->json($schools);
    }

    public function syncSchools()
    {
        $areaData = $this->bioTimeAreaService->getAreas();
        if(is_null($areaData))
        {           
            return redirect()->route('schools.index')->with('error', 'No data found. Please contact the system administrator.');
        }
        else 
        {
            $updateData = [];
            $createData = [];

            foreach ($areaData['data'] as $key => $value) {
                $temp = [];
               
                $faker = Faker::create();

                $temp['code'] = $value['area_code'];
                $temp['name'] = $value['area_name'];
                $temp['email_address'] = $faker->unique()->safeEmail;

                // Check if the school already exists by its code
                $school = School::where('code', $temp['code'])->first();

                if ($school) {
                    // If the school exists, add to update array
                    $updateData[] = [
                        'id' => $school->id, // Assuming 'id' is the primary key
                        'name' => $temp['name'],
                    ];
                } else {
                    // If the school doesn't exist, add to create array
                    $createData[] = $temp;
                }
            }

            // Bulk create new schools
            if (!empty($createData)) {
                School::insert($createData);
            }

            // Bulk update existing schools
            if (!empty($updateData)) {
                foreach ($updateData as $data) {
                    School::where('id', $data['id'])->update(['name' => $data['name']]);
                }
            }

            return redirect()->route('schools.index')->with('success', count($createData). ' new records inserted, '.count($updateData) .' records updated successfully!');
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\School  $school
     * @return \Illuminate\Http\Response
     */
    public function show(School $school)
    {
        return response()->json($school);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\School  $school
     * @return \Illuminate\Http\Response
     */
    public function edit(School $school)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\School  $school
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, School $school)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\School  $school
     * @return \Illuminate\Http\Response
     */
    public function destroy(School $school)
    {
        $school->delete();
        return response()->json(null, 204);
    }
}
