<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\User;
use App\Services\BioTimeTransactionService;

class TeamTransactionController extends Controller
{
    protected $bioTimeTransactionService;

    public function __construct(BioTimeTransactionService $bioTimeTransactionService)
    {
        $this->bioTimeTransactionService = $bioTimeTransactionService;
    }
    public function teamDayAttendance()
    {
        $userIds = User::where('manager_id', \Auth::id())->pluck('id')->toArray();
        $attendance = $this->bioTimeTransactionService->getTodaysPunchData($userIds);
        return view('pages/teamtransaction.dayAttendance', ['attendance' => $attendance]);
    }

    public function teamMembers()
    {
        $members = User::with(['department', 'schools'])->where('manager_id', \Auth::id())->get();
        return view('pages/teamtransaction.members', ['members' => $members]);
    }

    public function teamMemberAttendance(Request $request)
    {
        $userId = $request->input('userId');
        $user = User::find($userId);

        $monthType = $request->input('monthType', 'current');
    
        if ($monthType === 'previous') {
            $endDate = Carbon::now()->subMonth()->endOfMonth();
            $startDate = Carbon::now()->subMonth()->startOfMonth();
        } else { 
            $endDate = Carbon::now();
            $startDate = Carbon::now()->startOfMonth();
        }

        $attendance = $this->bioTimeTransactionService->getMonthlyEmployeeAttendance($userId, $startDate, $endDate);        
        return view('pages/teamtransaction.attendance', ['attendance' => $attendance, 'monthType' => $monthType, 'user' => $user]);
    }

    public function teammemberReport()
    {        
        $userIds = User::where('manager_id', \Auth::id())->pluck('id')->toArray();
        $attendanceCount = $this->bioTimeTransactionService->getCurrentMonthEmployeeDashboardAttendance($userIds);
        return view('pages/teamtransaction.teammemberReport',['attendanceCount' => $attendanceCount]);
    }
}
