<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\View;

class NotificationMiddleware
{
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->check()) {
            $headerNotifications = auth()->user()->notifications()->limit(10)->get();
            View::share('headerNotifications', $headerNotifications);
        }

        return $next($request);
    }
}
