<?php

namespace App\Livewire\Employee;

use Livewire\Component;
use App\Models\Position;

class PositionModal extends Component
{
    public $positions;
    public $external_id;
    public $code;
    public $name;
    public $parent_position;
    public $parent_position_name;
    public $position_id;

    public function render()
    {
        $this->positions = Position::all();
        return view('livewire.employee.position-modal');
    }

    public function store()
    {
        $this->validate([
            'external_id' => 'nullable|integer',
            'code' => 'nullable|string',
            'name' => 'required|string',
            'parent_position' => 'nullable|integer',
            'parent_position_name' => 'nullable|string',
        ]);

        Position::updateOrCreate(
            ['id' => $this->position_id],
            [
                'external_id' => $this->external_id,
                'code' => $this->code,
                'name' => $this->name,
                'parent_position' => $this->parent_position,
                'parent_position_name' => $this->parent_position_name,
            ]
        );

        $this->resetInputFields();
    }

    public function edit($id)
    {
        $position = Position::findOrFail($id);
        $this->position_id = $id;
        $this->external_id = $position->external_id;
        $this->code = $position->code;
        $this->name = $position->name;
        $this->parent_position = $position->parent_position;
        $this->parent_position_name = $position->parent_position_name;
    }

    public function delete($id)
    {
        Position::find($id)->delete();
    }

    private function resetInputFields()
    {
        $this->external_id = '';
        $this->code = '';
        $this->name = '';
        $this->parent_position = '';
        $this->parent_position_name = '';
        $this->position_id = '';
    }
}
