<?php

namespace App\Livewire\School;

use App\Models\School;
use Livewire\Component;
use Illuminate\Support\Facades\DB;

class SchoolModal extends Component
{
    public $school_id;
    public $code;
    public $name;
    public $email;
    public $address;
    public $city;
    public $state;
    public $postal_code;
    public $country;
    public $phone_number;
    public $email_address;
    public $principal_name;
    public $website_url;  

    public $edit_mode = false;

    protected $rules = [
        'code' => 'string|max:255|unique:schools',
        'name' => 'required|string|max:255|unique:schools',
        'address' => 'nullable|string|max:255',
        'city' => 'nullable|string|max:255',
        'state' => 'nullable|string|max:255',
        'postal_code' => 'nullable|string|max:20',
        'country' => 'nullable|string|max:255',
        'phone_number' => 'nullable|string|max:20',
        'email_address' => 'nullable|email|max:255|unique:schools',
        'principal_name' => 'nullable|string|max:255',
        'website_url' => 'nullable|url|max:255',
    ];

    protected $listeners = [
        'delete_school' => 'deleteSchool',
        'update_school' => 'updateSchool',
        'new_school' => 'hydrate',
    ];

    


    public function render()
    {
        return view('livewire.school.school-modal');
    }    

    public function submit()
    {
        $this->validate();

        DB::transaction(function () {
            $data = [
                'code' =>  $this->code,
                'name' => $this->name,
                'address' => $this->address,
                'city' => $this->city,
                'state' => $this->state,
                'postal_code' => $this->postal_code,
                'country' => $this->country,
                'phone_number' => $this->phone_number,
                'email_address' => $this->email_address,
                'principal_name' => $this->principal_name,
                'website_url' => $this->website_url,
            ];

            // Update or Create a new user record in the database
            $data['email'] = $this->email;
            $school = School::find($this->school_id) ?? School::create($data);

            if ($this->edit_mode) {
                foreach ($data as $k => $v) {
                    $school->$k = $v;
                }
                $user->save();
            }

            // Emit a success event with a message
            $this->dispatch('success', __('New School Created'));
        });

        // Reset the form fields after successful submission
        $this->reset();
    }

    public function deleteSchool($id)
    {
        // Delete the user record with the specified ID
        School::destroy($id);

        // Emit a success event with a message
        $this->dispatch('success', 'User successfully deleted');
    }

    public function updateSchool($id)
    {
        $this->edit_mode = true;

        $user = School::find($id);

        $this->user_id = $user->id;
        $this->saved_avatar = $user->profile_photo_url;
        $this->name = $user->name;
        $this->email = $user->email;
        $this->role = $user->roles?->first()->name ?? '';
    }

    public function hydrate()
    {
        $this->resetErrorBag();
        $this->resetValidation();
        $this->reset();
    }
}

