<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class School extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'code',
        'address',
        'city',
        'state',
        'postal_code',
        'country',
        'phone_number',
        'email_address',
        'principal_name',
        'type_of_school',
        'grades_offered',
        'number_of_students',
        'number_of_teachers',
        'established_year',
        'website_url',
    ];

    public function users()
    {
        return $this->belongsToMany(User::class, 'school_user', 'school_id', 'user_id');
    }
}
