<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShiftDetails extends Model
{
    use HasFactory;
    protected $table = 'shift_details';

    protected $fillable = [
        'shift_info_id',
        'start_date',
        'end_date',
        'day_of_week',
        'start_time',
        'end_time',
        'break_start_time',
        'break_end_time',
        'grace_in_minutes',
        'grace_out_minutes',
        'isDefault'
    ];

    public function shiftinfo()
    {
        return $this->belongsTo(ShiftInfo::class);
    }
}
