<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ShiftInfo extends Model
{
    use HasFactory;

    protected $table = 'shift_info';

    protected $fillable = [
        'user_id',
        'school_id',
        'shift_name',
        'shift_code'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function shiftDetails()
    {
        return $this->hasMany(ShiftDetails::class);
    }
}
