<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'emp',
        'emp_code',
        'punch_time',
        'punch_state',
        'punch_state_display',
        'verify_type',
        'verify_type_display',
        'area_alias',
        'terminal_sn',
        'is_corrected',
        'is_approved_leave',
        'upload_time',
    ];

    protected $casts = [
        'punch_time' => 'datetime',
        'upload_time' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function regularization()
    {
        return $this->hasOne(TransactionRegularization::class, 'transaction_id');
    }
}
