<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TransactionRegularization extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'attendance_date',
        'punch_in',
        'punch_out',
        'regularization_type',
        'transaction_id',
        'reason',
        'rejection_reason',
        'status',
        'approved_by',
        'approved_at'
    ];
    
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function approver()
    {
        return $this->belongsTo(User::class, 'approved_by');
    }

    public static function getMonthlyStatusCounts()
    {
        // Get the current month and year
        $currentMonth = now()->month;
        $currentYear = now()->year;

        // Get the count of Approved and Pending statuses for the current month
        $statusCounts = self::selectRaw('status, COUNT(*) as count')
            ->where('user_id', \Auth::id())
            ->whereYear('attendance_date', $currentYear)
            ->whereMonth('attendance_date', $currentMonth)
            ->groupBy('status')
            ->pluck('count', 'status');

        // Return the counts for Approved and Pending statuses
        return [
            'approved' => [
                'count' => $statusCounts->get('Approved', 0),
                'text' => "Regularization Approved",
                'bgcolor' => "#17c653",
            ],
            'pending' => [
                'count' => $statusCounts->get('Pending', 0),
                'text' => "Regularization Request",
                'bgcolor' => "#1b84ff",
            ]
        ];
    }

    public static function getListByStatus($status = 'pending')
    {
        $list = self::with('approver')->where('user_id', \Auth::id())->where('status', $status)->get();
        return $list;
    }
}
