<?php

namespace App\Services;
use App\Services\BioTimeApiService;

class BioTimeAreaService {
    
    protected $bioTimeApiService;

    public function __construct(BioTimeApiService $bioTimeApiService)
    {
        $this->bioTimeApiService = $bioTimeApiService;
    }

    public function getAreas()
    {
        $url = 'personnel/api/areas/';
        $parms = [];

        $headers = [
            'Content-Type' => 'application/json',
            'Authorization' => 'Token '.$this->bioTimeApiService->authenticateUser(),
        ];

        $response = $this->bioTimeApiService->get($url, $parms, $headers);
        

        if (isset($response['data'])) {
            return $response;
        }

        return null;
    }
    
}