<?php

namespace App\Services;
use App\Services\BioTimeApiService;

class BioTimeEmployeeService {
    
    protected $bioTimeApiService;

    public function __construct(BioTimeApiService $bioTimeApiService)
    {
        $this->bioTimeApiService = $bioTimeApiService;
    }

    public function getEmployees($emp_code)
    {
        $url = 'personnel/api/employees/';
        $params = [];
        $params['emp_code'] = $emp_code;
        $allData = [];

        try 
        {
            $headers = [
                'Content-Type' => 'application/json',
                'Authorization' => 'Token '.$this->bioTimeApiService->authenticateUser(),
            ];
            
            $response = $this->bioTimeApiService->get($url, $params, $headers);

            if (isset($response['data'])) {
                $allData = array_merge($allData, $response['data']);
            }

            return $allData;

        } catch (\Exception $e) {

            dd($e);
            return null;
        }
    }

    public function getEmployeesold()
    {
        $url = 'personnel/api/employees/';
        $params = [];
        $allData = [];

        try 
        {
            $headers = [
                'Content-Type' => 'application/json',
                'Authorization' => 'Token '.$this->bioTimeApiService->authenticateUser(),
            ];

            $count = 0;

            do {
                $response = $this->bioTimeApiService->get($url, $params, $headers);
                $count++;
                
                if (isset($response['data'])) {
                    $allData = array_merge($allData, $response['data']);
                }
                
                if (!empty($response['next'])) {                
                    $urlComponents = parse_url($response['next']);
                    parse_str($urlComponents['query'], $params);

                    if($count == 5)
                        $params = null;
                } else {
                    $params = null; 
                }

            } while ($params);
            
            return $allData;

        } catch (\Exception $e) {
            // Handle the exception (logging can be added here if needed)
            return null;
        }
    }
    
}