<?php

namespace App\Services;

class BioTimePositionService {
    
    protected $bioTimeApiService;

    public function __construct(BioTimeApiService $bioTimeApiService)
    {
        $this->bioTimeApiService = $bioTimeApiService;
    }

    public function getPositions()
    {
        $url = 'personnel/api/positions/';
        $params = [];
        $allData = [];

        try 
        {
            $headers = [
                'Content-Type' => 'application/json',
                'Authorization' => 'Token '.$this->bioTimeApiService->authenticateUser(),
            ];

            do {
                $response = $this->bioTimeApiService->get($url, $params, $headers);
                
                if (isset($response['data'])) {
                    $allData = array_merge($allData, $response['data']);
                }
                
                if (!empty($response['next'])) {                
                    $urlComponents = parse_url($response['next']);
                    parse_str($urlComponents['query'], $params);
                } else {
                    $params = null; 
                }

            } while ($params);
            
            return $allData;

        } catch (\Exception $e) {
            return null;
        }
    }
    
}