<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('external_id')->nullable();
            $table->unsignedBigInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');    
            $table->string('emp')->nullable();
            $table->string('emp_code')->nullable();
            $table->timestamp('punch_time')->nullable();
            $table->integer('punch_state')->nullable();
            $table->string('punch_state_display')->nullable();
            $table->integer('verify_type')->nullable();
            $table->string('verify_type_display')->nullable();
            $table->string('area_alias')->nullable();
            $table->string('terminal_sn')->nullable();            
            $table->boolean('is_corrected')->default(false);         
            $table->boolean('is_approved_leave')->default(false);
            $table->timestamp('upload_time')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
